/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.sqlclient;

import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.sqlclient.PreparedQuery;
import io.vertx.reactivex.sqlclient.Query;
import io.vertx.reactivex.sqlclient.Row;
import io.vertx.reactivex.sqlclient.RowSet;
import io.vertx.reactivex.sqlclient.SqlClient;
import io.vertx.reactivex.sqlclient.SqlConnection;
import io.vertx.reactivex.sqlclient.Transaction;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;

@RxGen(value=io.vertx.sqlclient.Pool.class)
public class Pool
extends SqlClient {
    public static final TypeArg<Pool> __TYPE_ARG = new TypeArg<Pool>(obj -> new Pool((io.vertx.sqlclient.Pool)obj), Pool::getDelegate);
    private final io.vertx.sqlclient.Pool delegate;
    private static final TypeArg<RowSet<Row>> TYPE_ARG_0 = new TypeArg<RowSet>(o1 -> RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new TypeArg<Row>(o2 -> Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());
    private static final TypeArg<RowSet<Row>> TYPE_ARG_1 = new TypeArg<RowSet>(o1 -> RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new TypeArg<Row>(o2 -> Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pool that = (Pool)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Pool(io.vertx.sqlclient.Pool delegate) {
        super((io.vertx.sqlclient.SqlClient)delegate);
        this.delegate = delegate;
    }

    public Pool(Object delegate) {
        super((io.vertx.sqlclient.SqlClient)((io.vertx.sqlclient.Pool)delegate));
        this.delegate = (io.vertx.sqlclient.Pool)delegate;
    }

    public io.vertx.sqlclient.Pool getDelegate() {
        return this.delegate;
    }

    public static Pool pool(SqlConnectOptions connectOptions) {
        Pool ret = Pool.newInstance(io.vertx.sqlclient.Pool.pool((SqlConnectOptions)connectOptions));
        return ret;
    }

    public static Pool pool(SqlConnectOptions connectOptions, PoolOptions poolOptions) {
        Pool ret = Pool.newInstance(io.vertx.sqlclient.Pool.pool((SqlConnectOptions)connectOptions, (PoolOptions)poolOptions));
        return ret;
    }

    public static Pool pool(io.vertx.reactivex.core.Vertx vertx, SqlConnectOptions connectOptions, PoolOptions poolOptions) {
        Pool ret = Pool.newInstance(io.vertx.sqlclient.Pool.pool((Vertx)vertx.getDelegate(), (SqlConnectOptions)connectOptions, (PoolOptions)poolOptions));
        return ret;
    }

    public void getConnection(final Handler<AsyncResult<SqlConnection>> handler) {
        this.delegate.getConnection((Handler)new Handler<AsyncResult<io.vertx.sqlclient.SqlConnection>>(){

            @Override
            public void handle(AsyncResult<io.vertx.sqlclient.SqlConnection> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(SqlConnection.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
    }

    public Single<SqlConnection> rxGetConnection() {
        return AsyncResultSingle.toSingle(handler -> this.getConnection((Handler<AsyncResult<SqlConnection>>)handler));
    }

    @Override
    public Query<RowSet<Row>> query(String sql) {
        Query<RowSet<Row>> ret = Query.newInstance(this.delegate.query(sql), TYPE_ARG_0);
        return ret;
    }

    @Override
    public PreparedQuery<RowSet<Row>> preparedQuery(String sql) {
        PreparedQuery<RowSet<Row>> ret = PreparedQuery.newInstance(this.delegate.preparedQuery(sql), TYPE_ARG_1);
        return ret;
    }

    public void begin(final Handler<AsyncResult<Transaction>> handler) {
        this.delegate.begin((Handler)new Handler<AsyncResult<io.vertx.sqlclient.Transaction>>(){

            @Override
            public void handle(AsyncResult<io.vertx.sqlclient.Transaction> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Transaction.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
    }

    public Single<Transaction> rxBegin() {
        return AsyncResultSingle.toSingle(handler -> this.begin((Handler<AsyncResult<Transaction>>)handler));
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    public static Pool newInstance(io.vertx.sqlclient.Pool arg) {
        return arg != null ? new Pool(arg) : null;
    }
}

