/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.nativeimage;

import java.io.IOException;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.impl.HeapDumpSupport;
import org.graalvm.nativeimage.impl.VMRuntimeSupport;

public final class VMRuntime {
    public static void initialize() {
        ImageSingletons.lookup(VMRuntimeSupport.class).executeStartupHooks();
    }

    public static void shutdown() {
        ImageSingletons.lookup(VMRuntimeSupport.class).shutdown();
    }

    public static void dumpHeap(String outputFile, boolean live) throws IOException {
        if (!ImageSingletons.contains(HeapDumpSupport.class)) {
            throw new UnsupportedOperationException();
        }
        ImageSingletons.lookup(HeapDumpSupport.class).dumpHeap(outputFile, live);
    }

    private VMRuntime() {
    }
}

