/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.runner;

import io.quarkus.bootstrap.runner.ClassLoadingResource;
import io.quarkus.bootstrap.runner.ManifestInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarResource
implements ClassLoadingResource {
    private final ManifestInfo manifestInfo;
    private final Path jarPath;
    private volatile ZipFile zipFile;

    public JarResource(ManifestInfo manifestInfo, Path jarPath) {
        this.manifestInfo = manifestInfo;
        this.jarPath = jarPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getResourceData(String resource) {
        ZipFile zipFile = this.file();
        ZipEntry entry = zipFile.getEntry(resource);
        if (entry == null) {
            return null;
        }
        try (InputStream is = zipFile.getInputStream(entry);){
            int read;
            byte[] data = new byte[(int)entry.getSize()];
            int pos = 0;
            for (int rem = data.length; rem > 0; pos += read, rem -= read) {
                read = is.read(data, pos, rem);
                if (read != -1) continue;
                throw new RuntimeException("Failed to read all data for " + resource);
            }
            byte[] byArray = data;
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read zip entry " + resource, e);
        }
    }

    @Override
    public URL getResourceURL(String resource) {
        ZipFile zipFile = this.file();
        ZipEntry entry = zipFile.getEntry(resource);
        if (entry == null) {
            return null;
        }
        try {
            URI jarUri = this.jarPath.toUri();
            return new URL("jar", null, jarUri.getScheme() + ":" + jarUri.getPath() + "!/" + resource);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ManifestInfo getManifestInfo() {
        return this.manifestInfo;
    }

    @Override
    public ProtectionDomain getProtectionDomain(ClassLoader classLoader) {
        URL url = null;
        try {
            String path = this.jarPath.toAbsolutePath().toString();
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            URI uri = new URI("file", null, path, null);
            url = uri.toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException("Unable to create protection domain for " + this.jarPath, e);
        }
        CodeSource codesource = new CodeSource(url, (Certificate[])null);
        return new ProtectionDomain(codesource, null, classLoader, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZipFile file() {
        if (this.zipFile == null) {
            JarResource jarResource = this;
            synchronized (jarResource) {
                if (this.zipFile == null) {
                    try {
                        this.zipFile = new ZipFile(this.jarPath.toFile());
                        return this.zipFile;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to open " + this.jarPath, e);
                    }
                }
            }
        }
        return this.zipFile;
    }

    @Override
    public void close() {
        if (this.zipFile != null) {
            try {
                this.zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

