/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc;

import io.quarkus.arc.InjectableBean;
import java.util.Map;
import java.util.function.Function;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.spi.AlterableContext;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;

public interface InjectableContext
extends AlterableContext {
    public void destroy();

    public ContextState getState();

    default public <T> T getIfActive(Contextual<T> contextual, Function<Contextual<T>, CreationalContext<T>> creationalContextFunction) {
        if (!this.isActive()) {
            return null;
        }
        T result = this.get(contextual);
        if (result != null) {
            return result;
        }
        return this.get(contextual, creationalContextFunction.apply(contextual));
    }

    default public void destroy(ContextState state) {
        for (InjectableBean<?> bean : state.getContextualInstances().keySet()) {
            try {
                this.destroy(bean);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to destroy contextual instance of " + bean, e);
            }
        }
    }

    default public boolean isNormal() {
        return this.getScope().isAnnotationPresent(NormalScope.class);
    }

    public static interface ContextState {
        public Map<InjectableBean<?>, Object> getContextualInstances();
    }
}

