/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime;

import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.security.runtime.SecurityProviderUtils;
import java.security.Provider;

@Recorder
public class SecurityProviderRecorder {
    public void addBouncyCastleProvider() {
        SecurityProviderUtils.addProvider(SecurityProviderUtils.loadProvider("org.bouncycastle.jce.provider.BouncyCastleProvider"));
    }

    public void addBouncyCastleJsseProvider() {
        Provider bc = SecurityProviderUtils.loadProvider("org.bouncycastle.jce.provider.BouncyCastleProvider");
        Provider bcJsse = SecurityProviderUtils.loadProvider("org.bouncycastle.jsse.provider.BouncyCastleJsseProvider");
        int sunJsseIndex = SecurityProviderUtils.findSunJSSEProviderIndex();
        SecurityProviderUtils.insertProvider(bc, sunJsseIndex);
        SecurityProviderUtils.insertProvider(bcJsse, sunJsseIndex + 1);
    }
}

