/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.Cancellable;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public class MultiOnCompletionCall<T>
extends AbstractMultiOperator<T, T> {
    private final Supplier<Uni<?>> supplier;

    public MultiOnCompletionCall(Multi<? extends T> upstream, Supplier<Uni<?>> supplier) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.supplier = ParameterValidation.nonNull(supplier, "supplier");
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        this.upstream.subscribe().withSubscriber(new MultiOnCompletionCallProcessor(ParameterValidation.nonNull(downstream, "downstream")));
    }

    class MultiOnCompletionCallProcessor
    extends MultiOperatorProcessor<T, T> {
        private final AtomicBoolean supplierInvoked;
        private volatile Cancellable cancellable;

        public MultiOnCompletionCallProcessor(MultiSubscriber<? super T> downstream) {
            super(downstream);
            this.supplierInvoked = new AtomicBoolean();
        }

        @Override
        public void onCompletion() {
            this.cancellable = this.execute().subscribe().with(ignored -> super.onCompletion(), err -> super.onFailure((Throwable)err));
        }

        @Override
        public void cancel() {
            if (this.cancellable != null) {
                this.cancellable.cancel();
            }
            super.cancel();
        }

        private Uni<?> execute() {
            if (this.supplierInvoked.compareAndSet(false, true)) {
                try {
                    return (Uni)ParameterValidation.nonNull(MultiOnCompletionCall.this.supplier.get(), "uni");
                }
                catch (Throwable err) {
                    return Uni.createFrom().failure(err);
                }
            }
            return Uni.createFrom().nullItem();
        }
    }
}

