/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.function.Consumer;

public class MultiOnItemInvoke<T>
extends AbstractMultiOperator<T, T> {
    private final Consumer<? super T> callback;

    public MultiOnItemInvoke(Multi<? extends T> upstream, Consumer<? super T> callback) {
        super(upstream);
        this.callback = callback;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        this.upstream.subscribe().withSubscriber(new MultiOnItemInvokeProcessor(ParameterValidation.nonNull(downstream, "downstream")));
    }

    class MultiOnItemInvokeProcessor
    extends MultiOperatorProcessor<T, T> {
        public MultiOnItemInvokeProcessor(MultiSubscriber<? super T> downstream) {
            super(downstream);
        }

        @Override
        public void onItem(T item) {
            if (this.upstream.get() != Subscriptions.CANCELLED) {
                MultiSubscriber subscriber = this.downstream;
                try {
                    MultiOnItemInvoke.this.callback.accept(item);
                }
                catch (Throwable t) {
                    this.failAndCancel(t);
                    return;
                }
                subscriber.onItem(item);
            }
        }
    }
}

