/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.logging;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Logger;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.StandardOutputStreams;
import org.jboss.logmanager.formatters.PatternFormatter;

public class QuarkusDelayedHandler
extends ExtHandler {
    public static final String QUARKUS_LOG_MAX_STARTUP_RECORDS = "quarkus-log-max-startup-records";
    private final Deque<ExtLogRecord> logRecords = new ArrayDeque<ExtLogRecord>();
    private final List<Runnable> logCloseTasks = new ArrayList<Runnable>();
    private final int queueLimit;
    private volatile boolean buildTimeLoggingActivated = false;
    private volatile boolean activated = false;
    private volatile boolean callerCalculationRequired = false;
    private int discardLevel = Integer.MIN_VALUE;
    private int lowestInQueue = Integer.MAX_VALUE;

    public QuarkusDelayedHandler() {
        this(Integer.getInteger(QUARKUS_LOG_MAX_STARTUP_RECORDS, 4000));
    }

    public QuarkusDelayedHandler(int queueLimit) {
        this.queueLimit = queueLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPublish(ExtLogRecord record) {
        if (this.activated) {
            this.publishToNestedHandlers(record);
            super.doPublish(record);
        } else {
            QuarkusDelayedHandler quarkusDelayedHandler = this;
            synchronized (quarkusDelayedHandler) {
                if (this.activated || this.buildTimeLoggingActivated) {
                    this.publishToNestedHandlers(record);
                    super.doPublish(record);
                } else {
                    if (record.getLevel().intValue() <= this.discardLevel) {
                        return;
                    }
                    if (this.logRecords.size() >= this.queueLimit) {
                        this.reportError("The delayed handler's queue was overrun and log record(s) were lost. Did you forget to configure logging?", null, 1);
                        this.compactQueue();
                        if (this.logRecords.size() >= this.queueLimit) {
                            return;
                        }
                        return;
                    }
                    if (this.isCallerCalculationRequired()) {
                        record.copyAll();
                    } else {
                        record.disableCallerCalculation();
                        record.copyMdc();
                    }
                    this.lowestInQueue = Integer.min(record.getLevel().intValue(), this.lowestInQueue);
                    this.logRecords.addLast(record);
                }
            }
        }
    }

    private void compactQueue() {
        if (this.lowestInQueue == Level.INFO.intValue()) {
            return;
        }
        int newLowest = Integer.MAX_VALUE;
        Iterator<ExtLogRecord> it = this.logRecords.iterator();
        while (it.hasNext()) {
            ExtLogRecord rec = it.next();
            if (rec.getLevel().intValue() == this.lowestInQueue) {
                it.remove();
                continue;
            }
            newLowest = Integer.min(rec.getLevel().intValue(), newLowest);
        }
        this.discardLevel = this.lowestInQueue;
        this.lowestInQueue = newLowest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws SecurityException {
        QuarkusDelayedHandler quarkusDelayedHandler = this;
        synchronized (quarkusDelayedHandler) {
            if (!this.logRecords.isEmpty()) {
                ExtLogRecord record;
                Formatter formatter = this.getFormatter();
                if (formatter == null) {
                    formatter = new PatternFormatter("%d{yyyy-MM-dd HH:mm:ss,SSS} %-5p [%c] (%t) %s%e%n");
                }
                StandardOutputStreams.printError("The DelayedHandler was closed before any children handlers were configured. Messages will be written to stderr.");
                while ((record = this.logRecords.pollFirst()) != null) {
                    StandardOutputStreams.printError(formatter.format(record));
                }
            }
        }
        this.activated = false;
        super.close();
    }

    @Override
    public void addHandler(Handler handler) throws SecurityException {
        super.addHandler(handler);
        this.activate();
    }

    @Override
    public Handler[] setHandlers(Handler[] newHandlers) throws SecurityException {
        Handler[] result = super.setHandlers(newHandlers);
        this.activate();
        return result;
    }

    public void addLoggingCloseTask(Runnable runnable) {
        this.logCloseTasks.add(runnable);
    }

    public synchronized Handler[] setBuildTimeHandlers(Handler[] newHandlers) throws SecurityException {
        ExtLogRecord record;
        Handler[] result = super.setHandlers(newHandlers);
        this.buildTimeLoggingActivated = true;
        while ((record = this.logRecords.pollFirst()) != null) {
            if (!this.isEnabled() || !this.isLoggable(record) || !Logger.getLogger(record.getLoggerName()).isLoggable(record.getLevel())) continue;
            this.publishToNestedHandlers(record);
        }
        return result;
    }

    public synchronized void buildTimeComplete() {
        this.buildTimeLoggingActivated = false;
    }

    @Override
    public void removeHandler(Handler handler) throws SecurityException {
        super.removeHandler(handler);
        this.activated = this.handlers.length != 0;
    }

    @Override
    public Handler[] clearHandlers() throws SecurityException {
        this.activated = false;
        for (Runnable i : this.logCloseTasks) {
            i.run();
        }
        return super.clearHandlers();
    }

    @Override
    public boolean isCallerCalculationRequired() {
        return this.callerCalculationRequired || super.isCallerCalculationRequired();
    }

    public void setCallerCalculationRequired(boolean callerCalculationRequired) {
        this.callerCalculationRequired = callerCalculationRequired;
    }

    public final boolean isActivated() {
        return this.activated;
    }

    private synchronized void activate() {
        ExtLogRecord record;
        while ((record = this.logRecords.pollFirst()) != null) {
            if (!this.isEnabled() || !this.isLoggable(record) || !Logger.getLogger(record.getLoggerName()).isLoggable(record.getLevel())) continue;
            this.publishToNestedHandlers(record);
        }
        this.activated = true;
    }
}

