/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.runner;

import io.quarkus.bootstrap.graal.ImageInfo;
import io.quarkus.bootstrap.logging.InitialConfigurator;
import java.math.BigDecimal;
import java.util.logging.Handler;
import org.jboss.logging.Logger;

public class Timing {
    public volatile long bootStartTime = -1L;
    private volatile long bootStopTime = -1L;
    private volatile String httpServerInfo = "";
    private static final String UNSET_VALUE = "<<unset>>";
    private static final Timing main = new Timing();
    private static final Timing auxiliary = new Timing();

    private static Timing get(boolean anc) {
        if (anc) {
            return auxiliary;
        }
        return main;
    }

    public static void staticInitStarted(boolean auxiliary) {
        Timing t = Timing.get(auxiliary);
        if (t.bootStartTime < 0L) {
            t.bootStartTime = System.nanoTime();
        }
    }

    public static void staticInitStarted(ClassLoader cl, boolean auxiliary) {
        try {
            Class<?> realTiming = cl.loadClass(Timing.class.getName());
            realTiming.getMethod("staticInitStarted", Boolean.TYPE).invoke(null, auxiliary);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void staticInitStopped(boolean auxiliary) {
        Timing t = Timing.get(auxiliary);
        if (t.bootStopTime < 0L) {
            t.bootStopTime = System.nanoTime();
        }
    }

    public static void setHttpServer(String info, boolean auxiliary) {
        Timing t = Timing.get(auxiliary);
        t.httpServerInfo = info;
    }

    public static void mainStarted() {
    }

    public static void restart() {
        Timing.main.bootStartTime = System.nanoTime();
    }

    public static void restart(ClassLoader cl) {
        try {
            Class<?> realTiming = cl.loadClass(Timing.class.getName());
            realTiming.getMethod("restart", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void printStartupTime(String name, String version, String quarkusVersion, String features, String profile, boolean liveCoding, boolean anc) {
        String nativeOrJvm;
        Timing t = Timing.get(anc);
        long bootTimeNanoSeconds = System.nanoTime() - t.bootStartTime;
        Logger logger2 = Logger.getLogger("io.quarkus");
        BigDecimal secondsRepresentation = Timing.convertToBigDecimalSeconds(bootTimeNanoSeconds);
        String safeAppName = name == null || name.trim().isEmpty() ? UNSET_VALUE : name;
        String safeAppVersion = version == null || version.trim().isEmpty() ? UNSET_VALUE : version;
        String string = nativeOrJvm = ImageInfo.inImageRuntimeCode() ? "native" : "on JVM";
        if (UNSET_VALUE.equals(safeAppName) || UNSET_VALUE.equals(safeAppVersion)) {
            logger2.infof("Quarkus %s %s started in %ss. %s", quarkusVersion, nativeOrJvm, secondsRepresentation, t.httpServerInfo);
        } else {
            logger2.infof("%s %s %s (powered by Quarkus %s) started in %ss. %s", name, version, nativeOrJvm, quarkusVersion, secondsRepresentation, t.httpServerInfo);
        }
        logger2.infof("Profile %s activated. %s", (Object)profile, (Object)(liveCoding ? "Live Coding activated." : ""));
        logger2.infof("Installed features: [%s]", (Object)features);
        t.bootStartTime = -1L;
    }

    public static void printStopTime(String name, boolean auxiliaryApplication) {
        Timing t = Timing.get(auxiliaryApplication);
        long stopTimeNanoSeconds = System.nanoTime() - t.bootStopTime;
        Logger logger2 = Logger.getLogger("io.quarkus");
        BigDecimal secondsRepresentation = Timing.convertToBigDecimalSeconds(stopTimeNanoSeconds);
        logger2.infof("%s stopped in %ss", (Object)(UNSET_VALUE.equals(name) || name == null || name.trim().isEmpty() ? "Quarkus" : name), (Object)secondsRepresentation);
        t.bootStopTime = -1L;
        if (!auxiliaryApplication) {
            Handler[] handlers;
            for (Handler handler : handlers = InitialConfigurator.DELAYED_HANDLER.clearHandlers()) {
                try {
                    handler.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public static BigDecimal convertToBigDecimalSeconds(long timeNanoSeconds) {
        BigDecimal secondsRepresentation = BigDecimal.valueOf(timeNanoSeconds).divide(BigDecimal.valueOf(1000000L), 4).divide(BigDecimal.valueOf(1000L), 3, 4);
        return secondsRepresentation;
    }
}

