/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.logstream;

import io.quarkus.vertx.http.runtime.logstream.JsonFormatter;
import io.vertx.core.http.ServerWebSocket;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;

public class WebSocketHandler
extends ExtHandler {
    private final ServerWebSocket session;

    public WebSocketHandler(ServerWebSocket session) {
        this.session = session;
        this.setFormatter(new JsonFormatter());
    }

    @Override
    public final void doPublish(ExtLogRecord record) {
        if (record.getMessage() == null || record.getMessage().isEmpty()) {
            return;
        }
        if (this.session != null && this.isLoggable(record)) {
            String message = this.getFormatter().format(record);
            try {
                this.session.writeTextMessage(message);
            }
            catch (Throwable ex) {
                this.session.close();
            }
        }
    }
}

