/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth;

import io.vertx.core.Vertx;
import io.vertx.ext.auth.VertxContextPRNG;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.concurrent.atomic.AtomicBoolean;

public class PRNG
implements VertxContextPRNG {
    private static final int DEFAULT_SEED_INTERVAL_MILLIS = 300000;
    private static final int DEFAULT_SEED_BITS = 64;
    private static final Base64.Encoder base64url = Base64.getUrlEncoder().withoutPadding();
    private final SecureRandom random;
    private final long seedID;
    private final Vertx vertx;
    private volatile boolean dirty = false;

    public PRNG(Vertx vertx) {
        this.vertx = vertx;
        String algorithm = System.getProperty("io.vertx.ext.auth.prng.algorithm");
        int seedInterval = Integer.getInteger("io.vertx.ext.auth.prng.seed.interval", 300000);
        int seedBits = Integer.getInteger("io.vertx.ext.auth.prng.seed.bits", 64);
        if (algorithm != null) {
            try {
                this.random = SecureRandom.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.random = new SecureRandom();
        }
        this.random.nextBytes(new byte[1]);
        if (seedInterval > 0 && seedBits > 0) {
            AtomicBoolean seeding = new AtomicBoolean(false);
            this.seedID = vertx.setPeriodic(seedInterval, id -> {
                if (this.dirty && seeding.compareAndSet(false, true)) {
                    vertx.executeBlocking(future -> future.complete(this.random.generateSeed(seedBits / 8)), false, generateSeed -> {
                        seeding.set(false);
                        this.dirty = false;
                        this.random.setSeed((byte[])generateSeed.result());
                    });
                }
            });
        } else {
            this.seedID = -1L;
        }
    }

    @Override
    public void close() {
        if (this.seedID != -1L) {
            this.vertx.cancelTimer(this.seedID);
        }
    }

    @Override
    public void nextBytes(byte[] bytes) {
        if (bytes != null) {
            this.random.nextBytes(bytes);
            this.dirty = true;
        }
    }

    @Override
    public int nextInt() {
        try {
            int n = this.random.nextInt();
            return n;
        }
        finally {
            this.dirty = true;
        }
    }

    @Override
    public int nextInt(int bound) {
        try {
            int n = this.random.nextInt(bound);
            return n;
        }
        finally {
            this.dirty = true;
        }
    }

    @Override
    public boolean nextBoolean() {
        try {
            boolean bl = this.random.nextBoolean();
            return bl;
        }
        finally {
            this.dirty = true;
        }
    }

    @Override
    public long nextLong() {
        try {
            long l = this.random.nextLong();
            return l;
        }
        finally {
            this.dirty = true;
        }
    }

    @Override
    public float nextFloat() {
        try {
            float f = this.random.nextFloat();
            return f;
        }
        finally {
            this.dirty = true;
        }
    }

    @Override
    public double nextDouble() {
        try {
            double d = this.random.nextDouble();
            return d;
        }
        finally {
            this.dirty = true;
        }
    }

    @Override
    public double nextGaussian() {
        try {
            double d = this.random.nextGaussian();
            return d;
        }
        finally {
            this.dirty = true;
        }
    }

    @Override
    public String nextString(int length) {
        byte[] data = new byte[length];
        this.nextBytes(data);
        return base64url.encodeToString(data);
    }
}

