/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.formatters;

import java.util.logging.Formatter;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.formatters.CompoundFormatStep;

public interface FormatStep {
    public static final FormatStep[] NO_STEPS = new FormatStep[0];
    public static final FormatStep NULL_STEP = new FormatStep(){

        @Override
        public void render(StringBuilder builder, ExtLogRecord record) {
        }

        @Override
        public int estimateLength() {
            return 0;
        }
    };

    public static FormatStep createCompoundStep(FormatStep ... steps) {
        FormatStep[] clonedSteps = (FormatStep[])steps.clone();
        if (clonedSteps.length == 0) {
            return NULL_STEP;
        }
        if (clonedSteps.length == 1) {
            return clonedSteps[0];
        }
        return new CompoundFormatStep(clonedSteps);
    }

    public void render(StringBuilder var1, ExtLogRecord var2);

    default public void render(Formatter formatter, StringBuilder builder, ExtLogRecord record) {
        this.render(builder, record);
    }

    public int estimateLength();

    default public boolean isCallerInformationRequired() {
        return false;
    }

    default public FormatStep[] childSteps() {
        return NO_STEPS;
    }

    default public int childStepCount() {
        return 0;
    }

    default public FormatStep getChildStep(int idx) {
        throw new IndexOutOfBoundsException();
    }

    default public ItemType getItemType() {
        return ItemType.GENERIC;
    }

    public static enum ItemType {
        GENERIC,
        COMPOUND,
        LEVEL,
        SOURCE_CLASS_NAME,
        DATE,
        SOURCE_FILE_NAME,
        HOST_NAME,
        SOURCE_LINE_NUMBER,
        LINE_SEPARATOR,
        CATEGORY,
        MDC,
        MESSAGE,
        EXCEPTION_TRACE,
        SOURCE_METHOD_NAME,
        SOURCE_MODULE_NAME,
        SOURCE_MODULE_VERSION,
        NDC,
        PROCESS_ID,
        PROCESS_NAME,
        RELATIVE_TIME,
        RESOURCE_KEY,
        SYSTEM_PROPERTY,
        TEXT,
        THREAD_ID,
        THREAD_NAME;

    }
}

