/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.EngineImpl;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.Expression;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.ResolutionContextImpl;
import io.quarkus.qute.Results;
import io.quarkus.qute.SectionNode;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.TemplateInstanceBase;
import io.quarkus.qute.Variant;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;

class TemplateImpl
implements Template {
    private final String generatedId;
    private final EngineImpl engine;
    private final Optional<Variant> variant;
    final SectionNode root;

    TemplateImpl(EngineImpl engine, SectionNode root, String generatedId, Optional<Variant> variant) {
        this.engine = engine;
        this.root = root;
        this.generatedId = generatedId;
        this.variant = variant;
    }

    @Override
    public TemplateInstance instance() {
        TemplateInstanceImpl instance = new TemplateInstanceImpl();
        if (!this.engine.initializers.isEmpty()) {
            for (TemplateInstance.Initializer initializer : this.engine.initializers) {
                initializer.accept(instance);
            }
        }
        return instance;
    }

    @Override
    public List<Expression> getExpressions() {
        return this.root.getExpressions();
    }

    @Override
    public String getGeneratedId() {
        return this.generatedId;
    }

    @Override
    public Optional<Variant> getVariant() {
        return this.variant;
    }

    static class DataNamespaceResolver
    implements NamespaceResolver {
        static final String ROOT_CONTEXT = "qute$rootContext";

        DataNamespaceResolver() {
        }

        @Override
        public CompletionStage<Object> resolve(EvalContext context) {
            Object rootContext = context.getAttribute(ROOT_CONTEXT);
            if (rootContext != null && rootContext instanceof ResolutionContext) {
                return ((ResolutionContext)rootContext).evaluate(context.getName());
            }
            return Results.notFound(context);
        }

        @Override
        public String getNamespace() {
            return "data";
        }
    }

    private class TemplateInstanceImpl
    extends TemplateInstanceBase {
        private TemplateInstanceImpl() {
        }

        @Override
        public String render() {
            try {
                Object timeoutAttr = this.getAttribute("timeout");
                long timeout = timeoutAttr != null ? Long.parseLong(timeoutAttr.toString()) : 10000L;
                return this.renderAsync().toCompletableFuture().get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
            catch (TimeoutException e) {
                throw new IllegalStateException(e);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new IllegalStateException(e.getCause());
            }
        }

        @Override
        public Multi<String> createMulti() {
            return Multi.createFrom().emitter(emitter -> this.consume(emitter::emit).whenComplete((r, f) -> {
                if (f == null) {
                    emitter.complete();
                } else {
                    emitter.fail((Throwable)f);
                }
            }));
        }

        @Override
        public Uni<String> createUni() {
            return Uni.createFrom().completionStage(this::renderAsync);
        }

        @Override
        public CompletionStage<String> renderAsync() {
            StringBuilder builder = new StringBuilder(1028);
            return this.renderData(this.data(), builder::append).thenApply(v -> builder.toString());
        }

        @Override
        public CompletionStage<Void> consume(Consumer<String> resultConsumer) {
            return this.renderData(this.data(), resultConsumer);
        }

        private CompletionStage<Void> renderData(Object data, Consumer<String> consumer) {
            CompletableFuture<Void> result = new CompletableFuture<Void>();
            ResolutionContextImpl rootContext = new ResolutionContextImpl(data, TemplateImpl.this.engine.getEvaluator(), null, this::getAttribute);
            this.setAttribute("qute$rootContext", rootContext);
            TemplateImpl.this.root.resolve(rootContext).whenComplete((r, t) -> {
                if (t != null) {
                    result.completeExceptionally((Throwable)t);
                } else {
                    try {
                        r.process(consumer);
                        result.complete(null);
                    }
                    catch (Throwable e) {
                        result.completeExceptionally(e);
                    }
                }
            });
            return result;
        }
    }
}

