/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.EngineImpl;
import io.quarkus.qute.Expression;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.ResolutionContextImpl;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.Results;
import io.quarkus.qute.SectionBlock;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.SectionInitContextImpl;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.jboss.logging.Logger;

class SectionNode
implements TemplateNode {
    private static final Logger LOG = Logger.getLogger("io.quarkus.qute.nodeResolve");
    final String name;
    final List<SectionBlock> blocks;
    private final SectionHelper helper;
    private final TemplateNode.Origin origin;
    private final boolean traceLevel;

    static Builder builder(String helperName, TemplateNode.Origin origin, Function<String, Expression> expressionFun, Function<String, TemplateException> errorFun) {
        return new Builder(helperName, origin, expressionFun, errorFun);
    }

    SectionNode(String name, List<SectionBlock> blocks, SectionHelper helper, TemplateNode.Origin origin) {
        this.name = name;
        this.blocks = blocks;
        this.helper = helper;
        this.origin = origin;
        this.traceLevel = LOG.isTraceEnabled();
    }

    @Override
    public CompletionStage<ResultNode> resolve(ResolutionContext context) {
        if (this.traceLevel && !"$root".equals(this.name)) {
            LOG.tracef("Resolve {#%s} started: %s", (Object)this.name, (Object)this.origin);
            return this.helper.resolve(new SectionResolutionContextImpl(context)).thenApply(r -> {
                LOG.tracef("Resolve {#%s} completed: %s", (Object)this.name, (Object)this.origin);
                return r;
            });
        }
        return this.helper.resolve(new SectionResolutionContextImpl(context));
    }

    @Override
    public TemplateNode.Origin getOrigin() {
        return this.origin;
    }

    void optimizeNodes(Set<TemplateNode> nodes) {
        for (SectionBlock block : this.blocks) {
            block.optimizeNodes(nodes);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SectionNode [helper=").append(this.helper.getClass().getSimpleName()).append(", origin= ").append(this.origin).append("]");
        return builder.toString();
    }

    @Override
    public List<Expression> getExpressions() {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        for (SectionBlock block : this.blocks) {
            expressions.addAll(block.getExpressions());
        }
        return expressions;
    }

    class SectionResolutionContextImpl
    implements SectionHelper.SectionResolutionContext {
        private final ResolutionContext resolutionContext;

        public SectionResolutionContextImpl(ResolutionContext resolutionContext) {
            this.resolutionContext = resolutionContext;
        }

        @Override
        public CompletionStage<ResultNode> execute(SectionBlock block, ResolutionContext context) {
            int size;
            if (block == null) {
                block = SectionNode.this.blocks.get(0);
            }
            if ((size = block.nodes.size()) == 1) {
                return block.nodes.get(0).resolve(context);
            }
            ArrayList<CompletionStage<ResultNode>> results = new ArrayList<CompletionStage<ResultNode>>(size);
            for (TemplateNode node : block.nodes) {
                results.add(node.resolve(context));
            }
            return Results.process(results);
        }

        @Override
        public ResolutionContext resolutionContext() {
            return this.resolutionContext;
        }

        @Override
        public ResolutionContext newResolutionContext(Object data, Map<String, SectionBlock> extendingBlocks) {
            return new ResolutionContextImpl(data, this.resolutionContext.getEvaluator(), extendingBlocks, this.resolutionContext::getAttribute);
        }
    }

    static class Builder {
        final String helperName;
        final TemplateNode.Origin origin;
        private final List<SectionBlock.Builder> blocks;
        private SectionBlock.Builder currentBlock;
        SectionHelperFactory<?> factory;
        private EngineImpl engine;

        Builder(String helperName, TemplateNode.Origin origin, Function<String, Expression> expressionFun, Function<String, TemplateException> errorFun) {
            this.helperName = helperName;
            this.origin = origin;
            this.blocks = new ArrayList<SectionBlock.Builder>();
            this.addBlock(SectionBlock.builder("$main", expressionFun, errorFun).setOrigin(origin));
        }

        Builder addBlock(SectionBlock.Builder block) {
            this.blocks.add(block);
            this.currentBlock = block;
            return this;
        }

        Builder endBlock() {
            this.currentBlock = this.blocks.get(0);
            return this;
        }

        SectionBlock.Builder currentBlock() {
            return this.currentBlock;
        }

        Builder setHelperFactory(SectionHelperFactory<?> factory) {
            this.factory = factory;
            return this;
        }

        Builder setEngine(EngineImpl engine) {
            this.engine = engine;
            return this;
        }

        SectionNode build() {
            ImmutableList.Builder<SectionBlock> builder = ImmutableList.builder();
            for (SectionBlock.Builder block : this.blocks) {
                builder.add(block.build());
            }
            List<SectionBlock> blocks = builder.build();
            return new SectionNode(this.helperName, blocks, (SectionHelper)this.factory.initialize(new SectionInitContextImpl(this.engine, blocks, this::createParserError)), this.origin);
        }

        TemplateException createParserError(String message) {
            StringBuilder builder = new StringBuilder("Parser error");
            if (!this.origin.getTemplateId().equals(this.origin.getTemplateGeneratedId())) {
                builder.append(" in template [").append(this.origin.getTemplateId()).append("]");
            }
            builder.append(" on line ").append(this.origin.getLine()).append(": ").append(message);
            return new TemplateException(this.origin, builder.toString());
        }
    }
}

