/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.quarkus.runtime.LaunchMode;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class HttpHostConfigSource
implements ConfigSource,
Serializable {
    public static final String QUARKUS_HTTP_HOST = "quarkus.http.host";
    private static final String ALL_INTERFACES = "0.0.0.0";
    private final int priority;

    public HttpHostConfigSource(int priority) {
        this.priority = priority;
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.singletonMap(QUARKUS_HTTP_HOST, this.getValue(QUARKUS_HTTP_HOST));
    }

    @Override
    public Set<String> getPropertyNames() {
        return Collections.singleton(QUARKUS_HTTP_HOST);
    }

    @Override
    public int getOrdinal() {
        return this.priority;
    }

    @Override
    public String getValue(String propertyName) {
        if (propertyName.equals(QUARKUS_HTTP_HOST)) {
            if (LaunchMode.isRemoteDev()) {
                return ALL_INTERFACES;
            }
            return LaunchMode.current().isDevOrTest() && !this.isWSL() ? "localhost" : ALL_INTERFACES;
        }
        return null;
    }

    private boolean isWSL() {
        Map<String, String> sysEnv = System.getenv();
        return sysEnv.containsKey("IS_WSL") || sysEnv.containsKey("WSL_DISTRO_NAME");
    }

    @Override
    public String getName() {
        return "Quarkus HTTP Host Default Value";
    }
}

