/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.qute.Engine;
import io.quarkus.qute.EngineBuilder;
import io.quarkus.qute.HtmlEscaper;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.ReflectionValueResolver;
import io.quarkus.qute.Resolver;
import io.quarkus.qute.Results;
import io.quarkus.qute.TemplateLocator;
import io.quarkus.qute.UserTagSectionHelper;
import io.quarkus.qute.ValueResolver;
import io.quarkus.qute.ValueResolvers;
import io.quarkus.qute.Variant;
import io.quarkus.qute.runtime.ContentTypes;
import io.quarkus.qute.runtime.PropertyNotFoundNoop;
import io.quarkus.qute.runtime.PropertyNotFoundOutputOriginal;
import io.quarkus.qute.runtime.PropertyNotFoundThrowException;
import io.quarkus.qute.runtime.QuteConfig;
import io.quarkus.qute.runtime.QuteRecorder;
import io.quarkus.qute.runtime.QuteRuntimeConfig;
import io.quarkus.runtime.Startup;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import org.jboss.logging.Logger;

@Startup(value=0)
@Singleton
public class EngineProducer {
    public static final String INJECT_NAMESPACE = "inject";
    private static final String TAGS = "tags/";
    private static final Logger LOGGER = Logger.getLogger(EngineProducer.class);
    private final Engine engine;
    private final ContentTypes contentTypes;
    private final List<String> tags;
    private final List<String> suffixes;
    private final String basePath;
    private final String tagPath;

    public EngineProducer(QuteRecorder.QuteContext context, QuteConfig config, QuteRuntimeConfig runtimeConfig, Event<EngineBuilder> builderReady, Event<Engine> engineReady, ContentTypes contentTypes) {
        this.contentTypes = contentTypes;
        this.suffixes = config.suffixes;
        this.basePath = "templates/";
        this.tagPath = this.basePath + TAGS;
        this.tags = context.getTags();
        LOGGER.debugf("Initializing Qute [templates: %s, tags: %s, resolvers: %s", (Object)context.getTemplatePaths(), (Object)this.tags, (Object)context.getResolverClasses());
        EngineBuilder builder = Engine.builder().addDefaultSectionHelpers();
        builder.addValueResolver(ValueResolvers.thisResolver());
        builder.addValueResolver(ValueResolvers.orResolver());
        builder.addValueResolver(ValueResolvers.trueResolver());
        builder.addValueResolver(ValueResolvers.collectionResolver());
        builder.addValueResolver(ValueResolvers.mapperResolver());
        builder.addValueResolver(ValueResolvers.mapEntryResolver());
        builder.addValueResolver(ValueResolvers.rawResolver());
        builder.addValueResolver(ValueResolvers.logicalAndResolver());
        builder.addValueResolver(ValueResolvers.logicalOrResolver());
        switch (runtimeConfig.propertyNotFoundStrategy) {
            case THROW_EXCEPTION: {
                builder.addResultMapper(new PropertyNotFoundThrowException());
                break;
            }
            case NOOP: {
                builder.addResultMapper(new PropertyNotFoundNoop());
                break;
            }
            case OUTPUT_ORIGINAL: {
                builder.addResultMapper(new PropertyNotFoundOutputOriginal());
                break;
            }
        }
        builder.addResultMapper(new HtmlEscaper());
        builder.addValueResolver(new ReflectionValueResolver());
        builder.removeStandaloneLines(runtimeConfig.removeStandaloneLines);
        builderReady.fire(builder);
        builder.addNamespaceResolver(NamespaceResolver.builder(INJECT_NAMESPACE).resolve(ctx -> {
            InstanceHandle bean = Arc.container().instance(ctx.getName());
            return bean.isAvailable() ? bean.get() : Results.Result.NOT_FOUND;
        }).build());
        for (String resolverClass : context.getResolverClasses()) {
            Resolver resolver = this.createResolver(resolverClass);
            if (resolver instanceof NamespaceResolver) {
                builder.addNamespaceResolver((NamespaceResolver)resolver);
            } else {
                builder.addValueResolver((ValueResolver)resolver);
            }
            LOGGER.debugf("Added generated value resolver: %s", (Object)resolverClass);
        }
        for (String tag : this.tags) {
            String tagName = tag.contains(".") ? tag.substring(0, tag.lastIndexOf(46)) : tag;
            String tagTemplateId = TAGS + tagName;
            LOGGER.debugf("Registered UserTagSectionHelper for %s [%s]", (Object)tagName, (Object)tagTemplateId);
            builder.addSectionHelper(new UserTagSectionHelper.Factory(tagName, tagTemplateId));
        }
        builder.addLocator(this::locate);
        this.engine = builder.build();
        for (String path : context.getTemplatePaths()) {
            this.engine.getTemplate(path);
        }
        engineReady.fire(this.engine);
    }

    @Produces
    @ApplicationScoped
    Engine getEngine() {
        return this.engine;
    }

    String getBasePath() {
        return this.basePath;
    }

    String getTagPath() {
        return this.tagPath;
    }

    private Resolver createResolver(String resolverClassName) {
        try {
            Class<?> resolverClazz = Thread.currentThread().getContextClassLoader().loadClass(resolverClassName);
            if (Resolver.class.isAssignableFrom(resolverClazz)) {
                return (Resolver)resolverClazz.newInstance();
            }
            throw new IllegalStateException("Not a resolver: " + resolverClassName);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Unable to create resolver: " + resolverClassName, e);
        }
    }

    private Optional<TemplateLocator.TemplateLocation> locate(String path) {
        URL resource = null;
        String templatePath = this.basePath + path;
        LOGGER.debugf("Locate template for %s", (Object)templatePath);
        resource = this.locatePath(templatePath);
        if (resource == null) {
            for (String suffix : this.suffixes) {
                templatePath = this.basePath + path + "." + suffix;
                resource = this.locatePath(templatePath);
                if (resource == null) continue;
                break;
            }
        }
        if (resource != null) {
            return Optional.of(new ResourceTemplateLocation(resource, this.guessVariant(templatePath)));
        }
        return Optional.empty();
    }

    private URL locatePath(String path) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = EngineProducer.class.getClassLoader();
        }
        return cl.getResource(path);
    }

    Variant guessVariant(String path) {
        return Variant.forContentType(this.contentTypes.getContentType(path));
    }

    static class ResourceTemplateLocation
    implements TemplateLocator.TemplateLocation {
        private final URL resource;
        private final Optional<Variant> variant;

        public ResourceTemplateLocation(URL resource, Variant variant) {
            this.resource = resource;
            this.variant = Optional.ofNullable(variant);
        }

        @Override
        public Reader read() {
            try {
                return new InputStreamReader(this.resource.openStream(), Charset.forName("utf-8"));
            }
            catch (IOException e) {
                return null;
            }
        }

        @Override
        public Optional<Variant> getVariant() {
            return this.variant;
        }
    }
}

