/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.impl.flow;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.auth.oauth2.impl.OAuth2API;
import io.vertx.ext.auth.oauth2.impl.OAuth2AuthProviderImpl;
import io.vertx.ext.auth.oauth2.impl.OAuth2TokenImpl;
import io.vertx.ext.auth.oauth2.impl.flow.AbstractOAuth2Flow;
import io.vertx.ext.auth.oauth2.impl.flow.OAuth2Flow;

public class AuthCodeImpl
extends AbstractOAuth2Flow
implements OAuth2Flow {
    private final OAuth2AuthProviderImpl provider;

    public AuthCodeImpl(OAuth2AuthProviderImpl provider) {
        super(provider.getVertx(), provider.getConfig());
        this.provider = provider;
        AuthCodeImpl.throwIfNull("clientId", this.config.getClientID());
    }

    @Override
    public String authorizeURL(JsonObject params) {
        JsonObject query = params.copy();
        if (query.containsKey("scopes")) {
            query.put("scope", String.join((CharSequence)this.config.getScopeSeparator(), query.getJsonArray("scopes").getList()));
            query.remove("scopes");
        }
        query.put("response_type", "code");
        query.put("client_id", this.config.getClientID());
        String path = this.config.getAuthorizationPath();
        String url = path.charAt(0) == '/' ? this.config.getSite() + path : path;
        return url + '?' + OAuth2API.stringify(query);
    }

    @Override
    public void getToken(JsonObject params, Handler<AsyncResult<AccessToken>> handler) {
        this.getToken("authorization_code", params, res -> {
            OAuth2TokenImpl token;
            if (res.failed()) {
                handler.handle(Future.failedFuture(res.cause()));
                return;
            }
            try {
                token = new OAuth2TokenImpl(this.provider, (JsonObject)res.result());
            }
            catch (RuntimeException e) {
                handler.handle(Future.failedFuture(e));
                return;
            }
            handler.handle(Future.succeededFuture(token));
        });
    }
}

