/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.vertx.codegen;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.ReadStreamSubscriber;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.codegen.lang.BufferRelatedMethodCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.ClassDeclarationCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.ClassJavadocCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.CodeGenHelper;
import io.smallrye.mutiny.vertx.codegen.lang.CodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.ConstantCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.ConstructorWithDelegateParameterCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.ConstructorWithGenericTypesCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.DelegateFieldCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.DelegateMethodDeclarationCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.FunctionApplyMethodCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.GetDelegateMethodCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.HashCodeAndEqualsMethodsCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.ImplClassCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.ImportDeclarationCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.IteratableMethodCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.IteratorMethodsCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.MutinyGenAnnotationCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.NewInstanceMethodCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.NewInstanceWithGenericsMethodCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.NoArgConstructorCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.PackageDeclarationCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.ReadStreamMethodDeclarationCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.ToMultiMethodCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.ToStringMethodCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.ToSubscriberCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.TypeArgsConstantCodeWriter;
import io.vertx.codegen.ClassModel;
import io.vertx.codegen.Generator;
import io.vertx.codegen.Helper;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.MethodKind;
import io.vertx.codegen.ModuleInfo;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.TypeParamInfo;
import io.vertx.codegen.annotations.ModuleGen;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.codegen.doc.Doc;
import io.vertx.codegen.doc.Token;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.PrimitiveTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractMutinyGenerator
extends Generator<ClassModel> {
    public static final String ID = "mutiny";
    private List<MethodInfo> methods = new ArrayList<MethodInfo>();
    private List<MethodInfo> forget = new ArrayList<MethodInfo>();
    private Map<MethodInfo, Map<TypeInfo, String>> methodTypeArgMap = new HashMap<MethodInfo, Map<TypeInfo, String>>();
    private List<CodeWriter> generators = Arrays.asList(new PackageDeclarationCodeWriter(), new ImportDeclarationCodeWriter(), new ClassJavadocCodeWriter(), new MutinyGenAnnotationCodeWriter(), new ClassDeclarationCodeWriter(), new TypeArgsConstantCodeWriter(), new DelegateFieldCodeWriter(), new ConstructorWithDelegateParameterCodeWriter(), new ConstructorWithGenericTypesCodeWriter(), new NoArgConstructorCodeWriter(), new GetDelegateMethodCodeWriter(), (mode, writer) -> this.methodTypeArgMap.forEach((method, map) -> map.forEach((typeArg, identifier) -> this.genTypeArgDecl((TypeInfo)typeArg, (MethodInfo)method, (String)identifier, writer))), new DelegateMethodDeclarationCodeWriter(), new BufferRelatedMethodCodeWriter(), new ToStringMethodCodeWriter(), new HashCodeAndEqualsMethodsCodeWriter(), new IteratableMethodCodeWriter(), new IteratorMethodsCodeWriter(), new FunctionApplyMethodCodeWriter(), new ToSubscriberCodeWriter(), new ReadStreamMethodDeclarationCodeWriter(), (model, writer) -> {
        if (model.isConcrete()) {
            this.generateClassBody(model, writer);
        } else {
            this.methods.forEach(method -> this.genMethodDecl(model, (MethodInfo)method, Collections.emptyList(), writer));
        }
    }, new ToMultiMethodCodeWriter(), new NewInstanceMethodCodeWriter(), new NewInstanceWithGenericsMethodCodeWriter(), (model, writer) -> writer.println("}"), new ImplClassCodeWriter(this));

    public AbstractMutinyGenerator() {
        this.kinds = Collections.singleton("class");
    }

    @Override
    public Collection<Class<? extends Annotation>> annotations() {
        return Arrays.asList(VertxGen.class, ModuleGen.class);
    }

    @Override
    public String filename(ClassModel model) {
        ModuleInfo module = model.getModule();
        return module.translateQualifiedName(model.getFqn(), ID) + ".java";
    }

    @Override
    public String render(ClassModel model, int index, int size, Map<String, Object> session) {
        this.initState(model);
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        this.generateClass(model, writer);
        return sw.toString();
    }

    private void initState(ClassModel model) {
        this.initGenMethods(model);
        this.initCachedTypeArgs();
    }

    private void generateClass(ClassModel model, PrintWriter writer) {
        this.generators.forEach(cw -> cw.apply(model, writer));
    }

    public void generateClassBody(ClassModel model, PrintWriter writer) {
        ArrayList cacheDecls = new ArrayList();
        this.methods.forEach(method -> this.genMethods(model, (MethodInfo)method, cacheDecls, writer));
        this.forget.forEach(method -> this.genForgetMethods(model, (MethodInfo)method, cacheDecls, writer));
        new ConstantCodeWriter(this.methodTypeArgMap).apply(model, writer);
        for (String cacheDecl : cacheDecls) {
            writer.print("  ");
            writer.print(cacheDecl);
            writer.println(";");
        }
    }

    private void initGenMethods(ClassModel model) {
        this.forget = new ArrayList<MethodInfo>();
        ArrayList<List<MethodInfo>> list = new ArrayList<List<MethodInfo>>();
        list.add(model.getMethods());
        list.add(model.getAnyJavaTypeMethods());
        list.forEach(methods -> {
            ListIterator it = methods.listIterator();
            while (it.hasNext()) {
                MethodInfo method = (MethodInfo)it.next();
                if (CodeGenHelper.methodKind(method) == MethodKind.FUTURE) continue;
                Predicate<MethodInfo> pred = method.isOwnedBy(model.getType()) ? other -> this.isOverride(method, (MethodInfo)other) : other -> this.isOverride(method, (MethodInfo)other);
                if (!methods.stream().filter(m -> CodeGenHelper.methodKind(m) == MethodKind.FUTURE).anyMatch(pred)) continue;
                this.forget.add(method);
                it.remove();
            }
            it = methods.listIterator();
            while (it.hasNext()) {
                MethodInfo meth = (MethodInfo)it.next();
                if (CodeGenHelper.methodKind(meth) != MethodKind.FUTURE) continue;
                List abc = model.getMethodMap().getOrDefault(meth.getName(), Collections.emptyList());
                boolean remove = meth.isOwnedBy(model.getType()) ? abc.stream().filter(m -> CodeGenHelper.methodKind(m) != MethodKind.FUTURE && this.isOverride((MethodInfo)m, meth)).anyMatch(m -> !m.isOwnedBy(model.getType()) || methods.contains(m)) : abc.stream().filter(other -> CodeGenHelper.methodKind(other) != MethodKind.FUTURE).anyMatch(other -> {
                    if (CodeGenHelper.methodKind(other) != MethodKind.FUTURE) {
                        HashSet<ClassTypeInfo> tmp = new HashSet<ClassTypeInfo>(other.getOwnerTypes());
                        tmp.retainAll(meth.getOwnerTypes());
                        return this.isOverride(meth, (MethodInfo)other) & !tmp.isEmpty();
                    }
                    return false;
                });
                if (!remove) continue;
                it.remove();
            }
        });
        this.methods = list.stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private void initCachedTypeArgs() {
        this.methodTypeArgMap.clear();
        int count = 0;
        for (MethodInfo method : this.methods) {
            TypeInfo returnType = method.getReturnType();
            if (!(returnType instanceof ParameterizedTypeInfo)) continue;
            ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)returnType;
            List<TypeInfo> typeArgs = parameterizedType.getArgs();
            HashMap<TypeInfo, String> typeArgMap = new HashMap<TypeInfo, String>();
            for (TypeInfo typeArg : typeArgs) {
                if (typeArg.getKind() != ClassKind.API || this.containsTypeVariableArgument(typeArg)) continue;
                String typeArgRef = "TYPE_ARG_" + count++;
                typeArgMap.put(typeArg, typeArgRef);
            }
            this.methodTypeArgMap.put(method, typeArgMap);
        }
    }

    private boolean containsTypeVariableArgument(TypeInfo type) {
        if (type.isVariable()) {
            return true;
        }
        if (type.isParameterized()) {
            List<TypeInfo> typeArgs = ((ParameterizedTypeInfo)type).getArgs();
            for (TypeInfo typeArg : typeArgs) {
                if (typeArg.isVariable()) {
                    return true;
                }
                if (!typeArg.isParameterized() || !this.containsTypeVariableArgument(typeArg)) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract void genMethods(ClassModel var1, MethodInfo var2, List<String> var3, PrintWriter var4);

    protected abstract void genForgetMethods(ClassModel var1, MethodInfo var2, List<String> var3, PrintWriter var4);

    protected abstract void genUniMethod(boolean var1, ClassModel var2, MethodInfo var3, PrintWriter var4);

    protected abstract void genBlockingMethod(boolean var1, ClassModel var2, MethodInfo var3, PrintWriter var4);

    protected abstract MethodInfo genConsumerMethodInfo(MethodInfo var1);

    protected abstract void genConsumerMethodInfo(boolean var1, ClassModel var2, MethodInfo var3, PrintWriter var4);

    private boolean isOverride(MethodInfo s1, MethodInfo s2) {
        if (s1.getName().equals(s2.getName()) && s1.getParams().size() == s2.getParams().size() - 1) {
            for (int i = 0; i < s1.getParams().size(); ++i) {
                if (s1.getParams().get(i).getType().equals(s2.getParams().get(i).getType())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    final void genMethod(ClassModel model, MethodInfo method, List<String> cacheDecls, PrintWriter writer) {
        if (CodeGenHelper.methodKind(method) == MethodKind.FUTURE) {
            this.genSimpleMethod(false, model, true, "__" + method.getName(), method, cacheDecls, writer);
            this.genUniMethod(false, model, method, writer);
            if (model.getMethods().stream().noneMatch(mi -> mi.getName().equals(method.getName() + "AndAwait"))) {
                this.genBlockingMethod(false, model, method, writer);
            }
        } else if (CodeGenHelper.methodKind(method) == MethodKind.HANDLER) {
            this.genSimpleMethod(false, model, true, "__" + method.getName(), method, cacheDecls, writer);
            this.genConsumerMethodInfo(false, model, method, writer);
        } else {
            this.genSimpleMethod(false, model, false, method.getName(), method, cacheDecls, writer);
        }
    }

    final void genForgetMethod(boolean decl, ClassModel model, MethodInfo method, List<String> cacheDecls, PrintWriter writer) {
        this.startMethodTemplate(false, method.getName() + "AndForget", method, new MethodDescriptor("", true, false, false), writer);
        if (decl) {
            writer.println(";");
            return;
        }
        writer.println(" { ");
        if (method.isFluent()) {
            writer.print("    ");
            writer.print(this.genInvokeDelegate(model, method));
            writer.println(";");
            if (method.getReturnType().isVariable()) {
                writer.print("    return (");
                writer.print(method.getReturnType().getName());
                writer.println(") this;");
            } else {
                writer.println("    return this;");
            }
        } else if (method.getReturnType().getName().equals("void")) {
            writer.print("    ");
            writer.print(this.genInvokeDelegate(model, method));
            writer.println(";");
        } else {
            if (method.isCacheReturn()) {
                writer.print("    if (cached_");
                writer.print(cacheDecls.size());
                writer.println(" != null) {");
                writer.print("      return cached_");
                writer.print(cacheDecls.size());
                writer.println(";");
                writer.println("    }");
            }
            TypeInfo returnType = method.getReturnType();
            String cachedType = method.getReturnType().getKind() == ClassKind.PRIMITIVE ? ((PrimitiveTypeInfo)returnType).getBoxed().getName() : CodeGenHelper.genTypeName(returnType);
            writer.print("    ");
            writer.print(CodeGenHelper.genTypeName(returnType));
            writer.print(" ret = ");
            writer.print(CodeGenHelper.genConvReturn(this.methodTypeArgMap, returnType, method, this.genInvokeDelegate(model, method)));
            writer.println(";");
            if (method.isCacheReturn()) {
                writer.print("    cached_");
                writer.print(cacheDecls.size());
                writer.println(" = ret;");
                cacheDecls.add("private" + (method.isStaticMethod() ? " static" : "") + " " + cachedType + " cached_" + cacheDecls.size());
            }
            writer.println("    return ret;");
        }
        writer.println("  }");
        writer.println();
    }

    private void genMethodDecl(ClassModel model, MethodInfo method, List<String> cacheDecls, PrintWriter writer) {
        if (CodeGenHelper.methodKind(method) == MethodKind.FUTURE) {
            this.genUniMethod(true, model, method, writer);
            if (!model.getMethods().stream().anyMatch(mi -> mi.getName().equals(method.getName() + "AndAwait"))) {
                this.genBlockingMethod(true, model, method, writer);
            }
        } else if (CodeGenHelper.methodKind(method) == MethodKind.HANDLER) {
            this.genConsumerMethodInfo(true, model, method, writer);
        } else {
            this.genSimpleMethod(true, model, false, method.getName(), method, cacheDecls, writer);
        }
    }

    void startMethodTemplate(boolean isPrivate, String methodName, MethodInfo method, MethodDescriptor descriptor, PrintWriter writer) {
        Doc doc = method.getDoc();
        String deprecated = descriptor.deprecated;
        String link = this.getJavadocLink(method.getOwnerTypes().iterator().next(), method);
        if (doc != null) {
            writer.println("  /**");
            if (descriptor.uni) {
                Token.toHtml(doc.getTokens(), "   *", CodeGenHelper::renderLinkToHtml, "\n", writer);
                writer.println("   * <p>");
                writer.println("   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link " + Uni.class.getName() + " Uni}.");
                writer.println("   * Don't forget to <em>subscribe</em> on it to trigger the operation.");
            }
            if (descriptor.andAwait) {
                writer.println("   * Blocking variant of " + link + ".");
                writer.println("   * <p>");
                writer.println("   * This method waits for the completion of the underlying asynchronous operation.");
                writer.println("   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).");
            }
            if (descriptor.andForget) {
                writer.println("   * Variant of " + link + " that ignores the result of the operation.");
                writer.println("   * <p>");
                writer.println("   * This method subscribes on the result of " + link + ", but discards the outcome (item or failure).");
                writer.println("   * This method is useful to trigger the asynchronous operation from " + link + " but you don't need to compose it with other operations.");
            }
            for (ParamInfo param : method.getParams()) {
                writer.print("   * @param ");
                writer.print(param.getName());
                writer.print(" ");
                if (param.getDescription() != null) {
                    Token.toHtml(param.getDescription().getTokens(), "", CodeGenHelper::renderLinkToHtml, "", writer);
                }
                writer.println();
            }
            if (!method.getReturnType().getName().equals("void")) {
                writer.print("   * @return ");
                if (method.getReturnDescription() != null) {
                    Token.toHtml(method.getReturnDescription().getTokens(), "", CodeGenHelper::renderLinkToHtml, "", writer);
                } else if (descriptor.uni) {
                    writer.print("the {@link " + Uni.class.getName() + " uni} firing the result of the operation when completed, or a failure if the operation failed.");
                } else if (descriptor.andAwait) {
                    writer.print("the " + method.getReturnType().getSimpleName() + " instance produced by the operation");
                }
                writer.println();
            }
            if (deprecated != null && deprecated.length() > 0) {
                writer.print("   * @deprecated ");
                writer.println(deprecated);
            }
            writer.println("   */");
        }
        if (method.isDeprecated() || deprecated != null && deprecated.length() > 0) {
            writer.println("  @Deprecated");
        }
        writer.print("  " + (isPrivate ? "private" : "public") + " ");
        if (method.isStaticMethod()) {
            writer.print("static ");
        }
        if (method.getTypeParams().size() > 0) {
            writer.print(method.getTypeParams().stream().map(TypeParamInfo::getName).collect(Collectors.joining(", ", "<", ">")));
            writer.print(" ");
        }
        writer.print(CodeGenHelper.genTypeName(method.getReturnType()));
        writer.print(" ");
        writer.print(methodName);
        writer.print("(");
        writer.print(method.getParams().stream().map(it -> CodeGenHelper.genTypeName(it.getType()) + " " + it.getName()).collect(Collectors.joining(", ")));
        writer.print(")");
    }

    private String getJavadocLink(ClassTypeInfo owner, MethodInfo method) {
        return CodeGenHelper.renderLinkToHtml(owner, method);
    }

    private void genSimpleMethod(boolean decl, ClassModel model, boolean isPrivate, String methodName, MethodInfo method, List<String> cacheDecls, PrintWriter writer) {
        this.startMethodTemplate(isPrivate, methodName, method, new MethodDescriptor("", false, false, false), writer);
        if (decl) {
            writer.println(";");
            return;
        }
        writer.println(" { ");
        if (method.isFluent()) {
            writer.print("    ");
            writer.print(this.genInvokeDelegate(model, method));
            writer.println(";");
            if (method.getReturnType().isVariable()) {
                writer.print("    return (");
                writer.print(method.getReturnType().getName());
                writer.println(") this;");
            } else {
                writer.println("    return this;");
            }
        } else if (method.getReturnType().getName().equals("void")) {
            writer.print("    ");
            writer.print(this.genInvokeDelegate(model, method));
            writer.println(";");
        } else {
            if (method.isCacheReturn()) {
                writer.print("    if (cached_");
                writer.print(cacheDecls.size());
                writer.println(" != null) {");
                writer.print("      return cached_");
                writer.print(cacheDecls.size());
                writer.println(";");
                writer.println("    }");
            }
            TypeInfo returnType = method.getReturnType();
            String cachedType = method.getReturnType().getKind() == ClassKind.PRIMITIVE ? ((PrimitiveTypeInfo)returnType).getBoxed().getName() : CodeGenHelper.genTypeName(returnType);
            writer.print("    ");
            writer.print(CodeGenHelper.genTypeName(returnType));
            writer.print(" ret = ");
            writer.print(CodeGenHelper.genConvReturn(this.methodTypeArgMap, returnType, method, this.genInvokeDelegate(model, method)));
            writer.println(";");
            if (method.isCacheReturn()) {
                writer.print("    cached_");
                writer.print(cacheDecls.size());
                writer.println(" = ret;");
                cacheDecls.add("private" + (method.isStaticMethod() ? " static" : "") + " " + cachedType + " cached_" + cacheDecls.size());
            }
            writer.println("    return ret;");
        }
        writer.println("  }");
        writer.println();
    }

    private String genInvokeDelegate(ClassModel model, MethodInfo method) {
        StringBuilder ret = method.isStaticMethod() ? new StringBuilder(Helper.getNonGenericType(model.getIfaceFQCN())) : new StringBuilder("delegate");
        ret.append(".").append(method.getName()).append("(");
        int index = 0;
        for (ParamInfo param : method.getParams()) {
            TypeInfo type;
            if (index > 0) {
                ret.append(", ");
            }
            if ((type = param.getType()).isParameterized() && type.getRaw().getName().equals("org.reactivestreams.Publisher")) {
                ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)type;
                String adapterFunction = parameterizedType.getArg(0).isVariable() ? "java.util.function.Function.identity()" : "obj -> (" + parameterizedType.getArg(0).getRaw().getName() + ")obj.getDelegate()";
                ret.append(ReadStreamSubscriber.class.getName()).append(".asReadStream(").append(param.getName()).append(",").append(adapterFunction).append(").resume()");
            } else {
                ret.append(CodeGenHelper.genConvParam(this.methodTypeArgMap, type, method, param.getName()));
            }
            ++index;
        }
        ret.append(")");
        return ret.toString();
    }

    private void genTypeArgDecl(TypeInfo typeArg, MethodInfo method, String typeArgRef, PrintWriter writer) {
        StringBuilder sb = new StringBuilder();
        CodeGenHelper.genTypeArg(typeArg, method, 1, sb);
        writer.print("  static final ");
        writer.print(TypeArg.class.getName());
        writer.print("<");
        writer.print(typeArg.translateName(ID));
        writer.print("> ");
        writer.print(typeArgRef);
        writer.print(" = ");
        writer.print(sb);
        writer.println(";");
    }

    protected static class MethodDescriptor {
        final String deprecated;
        final boolean andForget;
        final boolean andAwait;
        final boolean uni;

        MethodDescriptor(String deprecated, boolean andForget, boolean andAwait, boolean uni) {
            this.deprecated = deprecated;
            this.andForget = andForget;
            this.andAwait = andAwait;
            this.uni = uni;
        }
    }
}

