/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.inject;

import io.smallrye.config.ConfigMapping;
import io.smallrye.config.ConfigMappings;
import io.smallrye.config.ConfigValidationException;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.inject.ConfigInjectionBean;
import io.smallrye.config.inject.ConfigMappingInjectionBean;
import io.smallrye.config.inject.ConfigProducer;
import io.smallrye.config.inject.ConfigProducerUtil;
import io.smallrye.config.inject.InjectionMessages;
import io.smallrye.config.inject.SecuritySupport;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.inject.Provider;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.ConfigValue;
import org.eclipse.microprofile.config.inject.ConfigProperties;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class ConfigExtension
implements Extension {
    private final Set<InjectionPoint> configPropertyInjectionPoints = new HashSet<InjectionPoint>();
    private final Set<AnnotatedType<?>> configProperties = new HashSet();
    private final Set<InjectionPoint> configPropertiesInjectionPoints = new HashSet<InjectionPoint>();
    private final Set<AnnotatedType<?>> configMappings = new HashSet();
    private final Set<InjectionPoint> configMappingInjectionPoints = new HashSet<InjectionPoint>();

    protected void beforeBeanDiscovery(@Observes BeforeBeanDiscovery bbd, BeanManager bm) {
        AnnotatedType<ConfigProducer> configBean = bm.createAnnotatedType(ConfigProducer.class);
        bbd.addAnnotatedType(configBean, ConfigProducer.class.getName());
    }

    protected void processConfigProperties(@Observes @WithAnnotations(value={ConfigProperties.class}) ProcessAnnotatedType<?> processAnnotatedType) {
        if (processAnnotatedType.getAnnotatedType().isAnnotationPresent(ConfigProperties.class)) {
            processAnnotatedType.veto();
            this.configProperties.add(processAnnotatedType.getAnnotatedType());
        }
    }

    protected void processConfigMappings(@Observes @WithAnnotations(value={ConfigMapping.class}) ProcessAnnotatedType<?> processAnnotatedType) {
        if (processAnnotatedType.getAnnotatedType().isAnnotationPresent(ConfigMapping.class)) {
            processAnnotatedType.veto();
            this.configMappings.add(processAnnotatedType.getAnnotatedType());
        }
    }

    protected void processConfigInjectionPoints(@Observes ProcessInjectionPoint<?, ?> pip) {
        if (pip.getInjectionPoint().getAnnotated().isAnnotationPresent(ConfigProperty.class)) {
            this.configPropertyInjectionPoints.add(pip.getInjectionPoint());
        }
        if (pip.getInjectionPoint().getAnnotated().isAnnotationPresent(ConfigProperties.class)) {
            this.configPropertiesInjectionPoints.add(pip.getInjectionPoint());
        }
        if (pip.getInjectionPoint().getAnnotated().isAnnotationPresent(ConfigMapping.class)) {
            this.configMappingInjectionPoints.add(pip.getInjectionPoint());
        }
    }

    protected void registerCustomBeans(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        HashSet<Class> customTypes = new HashSet<Class>();
        for (InjectionPoint ip : this.configPropertyInjectionPoints) {
            Type requiredType = ip.getType();
            if (requiredType instanceof ParameterizedType) {
                Type typeArgument;
                ParameterizedType type = (ParameterizedType)requiredType;
                if (!type.getRawType().equals(Provider.class) && !type.getRawType().equals(Instance.class) || !((typeArgument = type.getActualTypeArguments()[0]) instanceof Class) || ConfigProducer.isClassHandledByConfigProducer(typeArgument)) continue;
                customTypes.add((Class)typeArgument);
                continue;
            }
            if (!(requiredType instanceof Class) || ConfigProducer.isClassHandledByConfigProducer(requiredType)) continue;
            customTypes.add((Class)requiredType);
        }
        customTypes.stream().map(customType -> new ConfigInjectionBean(bm, (Class<?>)customType)).forEach(abd::addBean);
        this.configProperties.stream().map(annotatedType -> new ConfigMappingInjectionBean(bm, annotatedType)).forEach(abd::addBean);
        this.configMappings.stream().map(annotatedType -> new ConfigMappingInjectionBean(bm, annotatedType)).forEach(abd::addBean);
    }

    protected void validate(@Observes AfterDeploymentValidation adv) {
        Config config = ConfigProvider.getConfig(SecuritySupport.getContextClassLoader());
        Set configNames = StreamSupport.stream(config.getPropertyNames().spliterator(), false).collect(Collectors.toSet());
        for (InjectionPoint injectionPoint : this.getConfigPropertyInjectionPoints()) {
            String name;
            Type type = injectionPoint.getType();
            if (type instanceof Class && ConfigValue.class.isAssignableFrom((Class)type) || type instanceof Class && OptionalInt.class.isAssignableFrom((Class)type) || type instanceof Class && OptionalLong.class.isAssignableFrom((Class)type) || type instanceof Class && OptionalDouble.class.isAssignableFrom((Class)type) || type instanceof ParameterizedType && (Optional.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType()) || Provider.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType()) || Supplier.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType()))) continue;
            ConfigProperty configProperty = injectionPoint.getAnnotated().getAnnotation(ConfigProperty.class);
            try {
                name = ConfigProducerUtil.getConfigKey(injectionPoint, configProperty);
            }
            catch (IllegalStateException e) {
                adv.addDeploymentProblem(InjectionMessages.msg.retrieveConfigFailure(null, InjectionMessages.formatInjectionPoint(injectionPoint), e.getLocalizedMessage(), e));
                continue;
            }
            if (!configNames.contains(name) && ConfigProducerUtil.getRawValue(name, config) == null && !ConfigExtension.isIndexed(type, name, config) && configProperty.defaultValue().equals("org.eclipse.microprofile.config.configproperty.unconfigureddvalue")) {
                adv.addDeploymentProblem(InjectionMessages.msg.noConfigValue(name, InjectionMessages.formatInjectionPoint(injectionPoint)));
                continue;
            }
            try {
                ConfigProducerUtil.getValue(injectionPoint, config);
            }
            catch (Exception e) {
                adv.addDeploymentProblem(InjectionMessages.msg.retrieveConfigFailure(name, InjectionMessages.formatInjectionPoint(injectionPoint), e.getLocalizedMessage(), e));
            }
        }
        Set<ConfigMappings.ConfigClassWithPrefix> configMappingsWithPrefix = ConfigExtension.mapToConfigObjectWithPrefix(this.configMappings, this.configMappingInjectionPoints);
        Set<ConfigMappings.ConfigClassWithPrefix> configPropertiesWithPrefix = ConfigExtension.mapToConfigObjectWithPrefix(this.configProperties, this.configPropertiesInjectionPoints);
        try {
            ConfigMappings.registerConfigMappings(config.unwrap(SmallRyeConfig.class), configMappingsWithPrefix);
            ConfigMappings.registerConfigProperties(config.unwrap(SmallRyeConfig.class), configPropertiesWithPrefix);
        }
        catch (ConfigValidationException e) {
            adv.addDeploymentProblem(e);
        }
    }

    protected Set<InjectionPoint> getConfigPropertyInjectionPoints() {
        return this.configPropertyInjectionPoints;
    }

    private static Set<ConfigMappings.ConfigClassWithPrefix> mapToConfigObjectWithPrefix(Set<AnnotatedType<?>> annotatedTypes, Set<InjectionPoint> injectionPoints) {
        HashSet<ConfigMappings.ConfigClassWithPrefix> configMappingsWithPrefix = new HashSet<ConfigMappings.ConfigClassWithPrefix>();
        for (AnnotatedType<?> annotatedType : annotatedTypes) {
            configMappingsWithPrefix.add(ConfigMappings.ConfigClassWithPrefix.configClassWithPrefix(annotatedType.getJavaClass(), ConfigMappingInjectionBean.getPrefixFromType(annotatedType)));
        }
        for (InjectionPoint injectionPoint : injectionPoints) {
            ConfigMappingInjectionBean.getPrefixFromInjectionPoint(injectionPoint).ifPresent(prefix -> configMappingsWithPrefix.add(ConfigMappings.ConfigClassWithPrefix.configClassWithPrefix((Class)injectionPoint.getType(), prefix)));
        }
        return configMappingsWithPrefix;
    }

    private static boolean isIndexed(Type type, String name, Config config) {
        return type instanceof ParameterizedType && (List.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType()) || Set.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType())) && !((SmallRyeConfig)config).getIndexedPropertiesIndexes(name).isEmpty();
    }
}

