/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.json.JsonValue;
import javax.json.bind.JsonbException;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.json.stream.JsonParser;
import org.eclipse.yasson.internal.ComponentMatcher;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.ReflectionUtils;
import org.eclipse.yasson.internal.components.AdapterBinding;
import org.eclipse.yasson.internal.components.DeserializerBinding;
import org.eclipse.yasson.internal.model.customization.ComponentBoundCustomization;
import org.eclipse.yasson.internal.model.customization.Customization;
import org.eclipse.yasson.internal.model.customization.PropertyCustomization;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.AbstractContainerDeserializer;
import org.eclipse.yasson.internal.serializer.AbstractItem;
import org.eclipse.yasson.internal.serializer.AbstractSerializerBuilder;
import org.eclipse.yasson.internal.serializer.AbstractValueTypeDeserializer;
import org.eclipse.yasson.internal.serializer.AdaptedObjectDeserializer;
import org.eclipse.yasson.internal.serializer.BooleanArrayDeserializer;
import org.eclipse.yasson.internal.serializer.ByteArrayBase64Deserializer;
import org.eclipse.yasson.internal.serializer.ByteArrayDeserializer;
import org.eclipse.yasson.internal.serializer.CharArrayDeserializer;
import org.eclipse.yasson.internal.serializer.CollectionDeserializer;
import org.eclipse.yasson.internal.serializer.DefaultSerializers;
import org.eclipse.yasson.internal.serializer.DoubleArrayDeserializer;
import org.eclipse.yasson.internal.serializer.FloatArrayDeserializer;
import org.eclipse.yasson.internal.serializer.IntArrayDeserializer;
import org.eclipse.yasson.internal.serializer.JsonArrayDeserializer;
import org.eclipse.yasson.internal.serializer.JsonObjectDeserializer;
import org.eclipse.yasson.internal.serializer.LongArrayDeserializer;
import org.eclipse.yasson.internal.serializer.MapDeserializer;
import org.eclipse.yasson.internal.serializer.MapEntriesArrayDeserializer;
import org.eclipse.yasson.internal.serializer.NullDeserializer;
import org.eclipse.yasson.internal.serializer.ObjectArrayDeserializer;
import org.eclipse.yasson.internal.serializer.ObjectDeserializer;
import org.eclipse.yasson.internal.serializer.OptionalObjectDeserializer;
import org.eclipse.yasson.internal.serializer.SerializerProviderWrapper;
import org.eclipse.yasson.internal.serializer.ShortArrayDeserializer;
import org.eclipse.yasson.internal.serializer.UserDeserializerDeserializer;

public class DeserializerBuilder
extends AbstractSerializerBuilder<DeserializerBuilder> {
    private JsonParser.Event jsonEvent;

    public DeserializerBuilder(JsonbContext jsonbContext) {
        super(jsonbContext);
    }

    public DeserializerBuilder withJsonValueType(JsonParser.Event event) {
        this.jsonEvent = event;
        return this;
    }

    public JsonbDeserializer<?> build() {
        JsonbDeserializer<?> deserializer;
        AbstractItem mapDeserializer;
        this.withRuntimeType(this.resolveRuntimeType());
        Class<?> rawType = ReflectionUtils.getRawType(this.getRuntimeType());
        Optional<Object> adapterInfoOptional = Optional.empty();
        Customization customization = this.getCustomization();
        if (customization == null || customization instanceof ComponentBoundCustomization) {
            ComponentBoundCustomization componentBoundCustomization = (ComponentBoundCustomization)((Object)customization);
            Object componentMatcher = this.getJsonbContext().getComponentMatcher();
            Optional<DeserializerBinding<?>> userDeserializer = ((ComponentMatcher)componentMatcher).getDeserializerBinding(this.getRuntimeType(), componentBoundCustomization);
            if (userDeserializer.isPresent()) {
                return new UserDeserializerDeserializer(this, userDeserializer.get());
            }
            Optional<AdapterBinding> adapterBinding = ((ComponentMatcher)componentMatcher).getDeserializeAdapterBinding(this.getRuntimeType(), componentBoundCustomization);
            if (adapterBinding.isPresent()) {
                adapterInfoOptional = adapterBinding;
                this.withRuntimeType(((AdapterBinding)adapterInfoOptional.get()).getToType());
                this.withWrapper(new AdaptedObjectDeserializer((AdapterBinding)adapterInfoOptional.get(), (AbstractContainerDeserializer)this.getWrapper()));
                rawType = ReflectionUtils.getRawType(this.getRuntimeType());
            }
        }
        if (Optional.class == rawType) {
            return new OptionalObjectDeserializer(this);
        }
        if (this.isByteArray(rawType)) {
            String strategy = this.getJsonbContext().getConfigProperties().getBinaryDataStrategy();
            switch (strategy) {
                case "BYTE": {
                    return new ByteArrayDeserializer(this);
                }
            }
            return new ByteArrayBase64Deserializer(customization);
        }
        if (this.isCharArray(rawType)) {
            return new CharArrayDeserializer(this);
        }
        if (DeserializerBuilder.isJsonValueEvent(this.jsonEvent)) {
            Optional<AbstractValueTypeDeserializer<?>> supportedTypeDeserializer = this.getSupportedTypeDeserializer(rawType);
            if (!supportedTypeDeserializer.isPresent()) {
                if (this.jsonEvent == JsonParser.Event.VALUE_NULL) {
                    return NullDeserializer.INSTANCE;
                }
                throw new JsonbException(Messages.getMessage(MessageKeys.DESERIALIZE_VALUE_ERROR, this.getRuntimeType()));
            }
            return this.wrapAdapted(adapterInfoOptional, (JsonbDeserializer)supportedTypeDeserializer.get());
        }
        if (this.jsonEvent == JsonParser.Event.START_ARRAY) {
            if (JsonValue.class.isAssignableFrom(rawType)) {
                return this.wrapAdapted(adapterInfoOptional, new JsonArrayDeserializer(this));
            }
            if (Map.class.isAssignableFrom(rawType)) {
                mapDeserializer = new MapEntriesArrayDeserializer(this);
                return this.wrapAdapted((Optional<AdapterBinding>)adapterInfoOptional, (JsonbDeserializer<?>)((Object)mapDeserializer));
            }
            if (rawType.isArray() || this.getRuntimeType() instanceof GenericArrayType) {
                deserializer = this.createArrayItem(rawType.getComponentType());
                return this.wrapAdapted(adapterInfoOptional, deserializer);
            }
            if (Collection.class.isAssignableFrom(rawType)) {
                deserializer = new CollectionDeserializer(this);
                return this.wrapAdapted(adapterInfoOptional, deserializer);
            }
            throw new JsonbException("Can't deserialize JSON array into: " + this.getRuntimeType());
        }
        if (this.jsonEvent == JsonParser.Event.START_OBJECT) {
            if (JsonValue.class.isAssignableFrom(rawType)) {
                return this.wrapAdapted(adapterInfoOptional, new JsonObjectDeserializer(this));
            }
            if (Map.class.isAssignableFrom(rawType)) {
                mapDeserializer = new MapDeserializer(this);
                return this.wrapAdapted((Optional<AdapterBinding>)adapterInfoOptional, (JsonbDeserializer<?>)((Object)mapDeserializer));
            }
            if (rawType.isInterface()) {
                Class<?> mappedType = this.getInterfaceMappedType(rawType);
                if (mappedType == null) {
                    throw new JsonbException(Messages.getMessage(MessageKeys.INFER_TYPE_FOR_UNMARSHALL, rawType.getName()));
                }
                this.withRuntimeType(mappedType);
                this.withClassModel(this.getClassModel(mappedType));
                return new ObjectDeserializer(this);
            }
            if (adapterInfoOptional.isPresent()) {
                this.withRuntimeType(((AdapterBinding)adapterInfoOptional.get()).getToType());
                rawType = ReflectionUtils.getRawType(this.getRuntimeType());
            }
            this.withClassModel(this.getClassModel(rawType));
            deserializer = new ObjectDeserializer(this);
            return this.wrapAdapted(adapterInfoOptional, deserializer);
        }
        throw new JsonbException("unresolved type for deserialization: " + this.getRuntimeType());
    }

    public static boolean isJsonValueEvent(JsonParser.Event event) {
        switch (event) {
            case VALUE_NULL: 
            case VALUE_FALSE: 
            case VALUE_TRUE: 
            case VALUE_NUMBER: 
            case VALUE_STRING: {
                return true;
            }
        }
        return false;
    }

    private Optional<AbstractValueTypeDeserializer<?>> getSupportedTypeDeserializer(Class<?> rawType) {
        Optional<SerializerProviderWrapper> supportedTypeDeserializerOptional = DefaultSerializers.getInstance().findValueSerializerProvider(rawType);
        if (supportedTypeDeserializerOptional.isPresent()) {
            return Optional.of(supportedTypeDeserializerOptional.get().getDeserializerProvider().provideDeserializer(this.getCustomization()));
        }
        return Optional.empty();
    }

    private JsonbDeserializer<?> wrapAdapted(Optional<AdapterBinding> adapterInfoOptional, JsonbDeserializer<?> item) {
        Optional<JsonbDeserializer> adaptedDeserializerOptional = adapterInfoOptional.map(adapterInfo -> {
            this.setAdaptedItemCaptor((AdaptedObjectDeserializer)this.getWrapper(), item);
            return (JsonbDeserializer)((Object)this.getWrapper());
        });
        return adaptedDeserializerOptional.orElse(item);
    }

    private <T, A> void setAdaptedItemCaptor(AdaptedObjectDeserializer<T, A> decoratorItem, JsonbDeserializer<T> adaptedItem) {
        decoratorItem.setAdaptedTypeDeserializer(adaptedItem);
    }

    private Type resolveRuntimeType() {
        Type result = ReflectionUtils.resolveType(this.getWrapper(), this.getGenericType() != null ? this.getGenericType() : this.getRuntimeType());
        if (result == Object.class) {
            switch (this.jsonEvent) {
                case VALUE_FALSE: 
                case VALUE_TRUE: {
                    return Boolean.class;
                }
                case VALUE_NUMBER: {
                    return BigDecimal.class;
                }
                case VALUE_STRING: {
                    return String.class;
                }
                case START_ARRAY: {
                    return ArrayList.class;
                }
                case START_OBJECT: {
                    return this.getJsonbContext().getConfigProperties().getDefaultMapImplType();
                }
                case VALUE_NULL: {
                    return Object.class;
                }
            }
            throw new IllegalStateException("Can't infer deserialization type type: " + (Object)((Object)this.jsonEvent));
        }
        return result;
    }

    private Class<?> getInterfaceMappedType(Class<?> interfaceType) {
        if (interfaceType.isInterface()) {
            Class<?> implementationClass = null;
            if (this.getCustomization() instanceof PropertyCustomization) {
                implementationClass = ((PropertyCustomization)this.getCustomization()).getImplementationClass();
            }
            if (implementationClass == null) {
                implementationClass = this.getJsonbContext().getConfigProperties().getUserTypeMapping().get(interfaceType);
            }
            if (implementationClass != null) {
                if (!interfaceType.isAssignableFrom(implementationClass)) {
                    throw new JsonbException(Messages.getMessage(MessageKeys.IMPL_CLASS_INCOMPATIBLE, implementationClass, interfaceType));
                }
                return implementationClass;
            }
        }
        return null;
    }

    private JsonbDeserializer<?> createArrayItem(Class<?> componentType) {
        if (componentType == Byte.TYPE) {
            return new ByteArrayDeserializer(this);
        }
        if (componentType == Short.TYPE) {
            return new ShortArrayDeserializer(this);
        }
        if (componentType == Integer.TYPE) {
            return new IntArrayDeserializer(this);
        }
        if (componentType == Long.TYPE) {
            return new LongArrayDeserializer(this);
        }
        if (componentType == Float.TYPE) {
            return new FloatArrayDeserializer(this);
        }
        if (componentType == Double.TYPE) {
            return new DoubleArrayDeserializer(this);
        }
        if (componentType == Boolean.TYPE) {
            return new BooleanArrayDeserializer(this);
        }
        return new ObjectArrayDeserializer(this);
    }

    private boolean isByteArray(Class<?> rawType) {
        return rawType.isArray() && rawType.getComponentType() == Byte.TYPE;
    }

    private boolean isCharArray(Class<?> rawType) {
        return rawType.isArray() && rawType.getComponentType() == Character.TYPE;
    }
}

