/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.Type;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import javax.json.bind.JsonbException;
import javax.json.bind.serializer.JsonbSerializer;
import javax.json.bind.serializer.SerializationContext;
import javax.json.stream.JsonGenerator;
import org.eclipse.yasson.internal.Marshaller;
import org.eclipse.yasson.internal.ReflectionUtils;
import org.eclipse.yasson.internal.model.ClassModel;
import org.eclipse.yasson.internal.model.PropertyModel;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.AbstractContainerSerializer;
import org.eclipse.yasson.internal.serializer.CurrentItem;
import org.eclipse.yasson.internal.serializer.SerializerBuilder;

public class ObjectSerializer<T>
extends AbstractContainerSerializer<T> {
    public ObjectSerializer(SerializerBuilder builder) {
        super(builder);
    }

    public ObjectSerializer(CurrentItem<?> wrapper, Type runtimeType, ClassModel classModel) {
        super(wrapper, runtimeType, classModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void serializeInternal(T object, JsonGenerator generator, SerializationContext ctx) {
        block7: {
            Marshaller context = (Marshaller)ctx;
            try {
                if (context.addProcessedObject(object)) {
                    PropertyModel[] allProperties;
                    for (PropertyModel model : allProperties = context.getMappingContext().getOrCreateClassModel(object.getClass()).getSortedProperties()) {
                        try {
                            this.marshallProperty(object, generator, context, model);
                        }
                        catch (Exception e) {
                            throw new JsonbException(Messages.getMessage(MessageKeys.SERIALIZE_PROPERTY_ERROR, model.getWriteName(), object.getClass().getCanonicalName()), e);
                        }
                    }
                    break block7;
                }
                throw new JsonbException(Messages.getMessage(MessageKeys.RECURSIVE_REFERENCE, object.getClass()));
            }
            finally {
                context.removeProcessedObject(object);
            }
        }
    }

    @Override
    protected void writeStart(JsonGenerator generator) {
        generator.writeStartObject();
    }

    @Override
    protected void writeStart(String key, JsonGenerator generator) {
        generator.writeStartObject(key);
    }

    private void marshallProperty(T object, JsonGenerator generator, SerializationContext ctx, PropertyModel propertyModel) {
        Marshaller marshaller = (Marshaller)ctx;
        if (propertyModel.isReadable()) {
            Object propertyValue = propertyModel.getValue(object);
            if (propertyValue == null || this.isEmptyOptional(propertyValue)) {
                if (propertyModel.getCustomization().isNillable()) {
                    generator.writeNull(propertyModel.getWriteName());
                }
                return;
            }
            generator.writeKey(propertyModel.getWriteName());
            JsonbSerializer<?> propertyCachedSerializer = propertyModel.getPropertySerializer();
            if (propertyCachedSerializer != null) {
                this.serializerCaptor(propertyCachedSerializer, propertyValue, generator, ctx);
                return;
            }
            Optional<Type> runtimeTypeOptional = ReflectionUtils.resolveOptionalType(this, propertyModel.getPropertySerializationType());
            Type genericType = runtimeTypeOptional.orElse(null);
            JsonbSerializer<?> serializer = ((SerializerBuilder)((SerializerBuilder)((SerializerBuilder)new SerializerBuilder(marshaller.getJsonbContext()).withWrapper(this)).withObjectClass(propertyValue.getClass()).withCustomization(propertyModel.getCustomization())).withType(genericType)).build();
            this.serializerCaptor(serializer, propertyValue, generator, ctx);
        }
    }

    private boolean isEmptyOptional(Object object) {
        if (object instanceof Optional) {
            return !((Optional)object).isPresent();
        }
        if (object instanceof OptionalInt) {
            return !((OptionalInt)object).isPresent();
        }
        if (object instanceof OptionalLong) {
            return !((OptionalLong)object).isPresent();
        }
        if (object instanceof OptionalDouble) {
            return !((OptionalDouble)object).isPresent();
        }
        return false;
    }
}

