/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.specimpl;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.RuntimeDelegate;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.specimpl.PathSegmentImpl;
import org.jboss.resteasy.specimpl.ResteasyUriBuilderImpl;
import org.jboss.resteasy.specimpl.UnmodifiableMultivaluedMap;
import org.jboss.resteasy.spi.ResteasyUriBuilder;
import org.jboss.resteasy.util.Encode;
import org.jboss.resteasy.util.PathHelper;

public class ResteasyUriInfo
implements UriInfo {
    private String path;
    private String encodedPath;
    private String matchingPath;
    private MultivaluedMap<String, String> queryParameters;
    private MultivaluedMap<String, String> encodedQueryParameters;
    private MultivaluedMap<String, String> pathParameters;
    private MultivaluedMap<String, String> encodedPathParameters;
    private MultivaluedMap<String, PathSegment[]> pathParameterPathSegments;
    private MultivaluedMap<String, PathSegment[]> encodedPathParameterPathSegments;
    private List<PathSegment> pathSegments;
    private List<PathSegment> encodedPathSegments;
    private URI absolutePath;
    private URI requestURI;
    private URI baseURI;
    private List<String> matchedUris;
    private List<String> encodedMatchedUris;
    private List<String> encodedMatchedPaths = new LinkedList<String>();
    private List<Object> ancestors;
    private String absoluteString;
    private String contextPath;
    private int queryIdx;
    private int pathStart;

    public ResteasyUriInfo(String absoluteUri, String contextPath) {
        this(absoluteUri, contextPath, null);
    }

    public ResteasyUriInfo(String absoluteUri, String contextPath, InitData initData) {
        this.initialize(absoluteUri, contextPath, initData != null && InitData.canBeCached(absoluteUri) ? initData : null);
    }

    protected void initialize(String absoluteUri, String contextPath, InitData initData) {
        this.absoluteString = absoluteUri;
        this.contextPath = contextPath;
        if (initData == null) {
            initData = new InitData(absoluteUri, contextPath);
        }
        this.queryIdx = initData.getQueryIdx();
        this.pathStart = initData.getPathStart();
        this.encodedPath = initData.getEncodedPath();
        this.path = initData.getPath();
        this.encodedPathSegments = initData.getEncodedPathSegments();
        this.pathSegments = initData.getPathSegments();
        this.matchingPath = initData.getMatchingPath();
    }

    protected void initialize(CharSequence absoluteUri, String queryString, String contextPath) {
        ResteasyUriBuilder absoluteBuilder = (ResteasyUriBuilder)((ResteasyUriBuilder)RuntimeDelegate.getInstance().createUriBuilder()).uriFromCharSequence(absoluteUri);
        this.absolutePath = absoluteBuilder.build(new Object[0]);
        this.requestURI = absoluteBuilder.replaceQuery(queryString).build(new Object[0]);
        this.encodedPath = PathHelper.getEncodedPathInfo(this.absolutePath.getRawPath(), contextPath);
        this.baseURI = this.absolutePath;
        if (!this.encodedPath.trim().equals("")) {
            String tmpContextPath = contextPath;
            if (!tmpContextPath.endsWith("/")) {
                tmpContextPath = tmpContextPath + "/";
            }
            this.baseURI = absoluteBuilder.clone().replacePath(tmpContextPath).replaceQuery(null).build(new Object[0]);
        }
        if (this.encodedPath.length() == 0 || this.encodedPath.charAt(0) != '/') {
            this.encodedPath = "/" + this.encodedPath;
        }
        this.path = UriBuilder.fromPath(this.encodedPath).build(new Object[0]).getPath();
        this.processPath();
    }

    public ResteasyUriInfo(URI base, URI relative) {
        String r;
        String b = base.toString();
        if (!b.endsWith("/")) {
            b = b + "/";
        }
        if ((r = relative.getRawPath()).startsWith("/")) {
            this.encodedPath = r;
            this.path = relative.getPath();
        } else {
            this.encodedPath = "/" + r;
            this.path = "/" + relative.getPath();
        }
        UriBuilder requestUriBuilder = UriBuilder.fromUri(base).path(relative.getRawPath()).replaceQuery(relative.getRawQuery());
        this.requestURI = requestUriBuilder.build(new Object[0]);
        this.absolutePath = requestUriBuilder.replaceQuery(null).build(new Object[0]);
        this.baseURI = base;
        this.processPath();
    }

    public void setUri(URI base, URI relative) {
        this.clearQueryParameters(true);
        this.clearQueryParameters(false);
        URI rel = base.resolve(relative);
        String absoluteUri = UriBuilder.fromUri(rel).replaceQuery(null).toTemplate();
        this.initialize((CharSequence)absoluteUri, rel.getRawQuery(), base.getRawPath());
    }

    protected void processPath() {
        ProcessPathResult processPathResult = ResteasyUriInfo.doProcessPath(this.encodedPath);
        this.encodedPathSegments = processPathResult.getEncodedPathSegments();
        this.pathSegments = processPathResult.getPathSegments();
        this.matchingPath = processPathResult.getMatchingPath();
    }

    private static ProcessPathResult doProcessPath(String encodedPath) {
        String matchingPath;
        PathSegmentImpl.SegmentParse parse = PathSegmentImpl.parseSegmentsOptimization(encodedPath, false);
        List<PathSegment> encodedPathSegments = parse.segments;
        ArrayList<PathSegmentImpl> pathSegments = new ArrayList<PathSegmentImpl>(encodedPathSegments.size());
        for (PathSegment segment : encodedPathSegments) {
            pathSegments.add(new PathSegmentImpl(((PathSegmentImpl)segment).getOriginal(), true));
        }
        if (parse.hasMatrixParams) {
            matchingPath = ResteasyUriInfo.doExtractMatchingPath(encodedPathSegments);
        } else {
            matchingPath = encodedPath;
            if (matchingPath.length() > 1 && matchingPath.endsWith("/")) {
                matchingPath = matchingPath.substring(0, matchingPath.length() - 1);
            }
        }
        return new ProcessPathResult(encodedPathSegments, pathSegments, matchingPath);
    }

    public ResteasyUriInfo(URI requestURI) {
        this.initializeFromRequest(requestURI);
    }

    public void initializeFromRequest(URI requestURI) {
        String r = requestURI.getRawPath();
        if (r.startsWith("/")) {
            this.encodedPath = r;
            this.path = requestURI.getPath();
        } else {
            this.encodedPath = "/" + r;
            this.path = "/" + requestURI.getPath();
        }
        this.requestURI = requestURI;
        this.baseURI = UriBuilder.fromUri(requestURI).replacePath("").build(new Object[0]);
        this.absolutePath = UriBuilder.fromUri(requestURI).replaceQuery(null).build(new Object[0]);
        this.processPath();
    }

    private static String doExtractMatchingPath(List<PathSegment> encodedPathSegments) {
        StringBuilder preprocessedPath = new StringBuilder();
        for (PathSegment pathSegment : encodedPathSegments) {
            preprocessedPath.append("/").append(pathSegment.getPath());
        }
        return preprocessedPath.toString();
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getMatchingPath() {
        return this.matchingPath;
    }

    public void setRequestUri(URI relative) {
        this.setUri(this.getBaseUri(), relative);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getPath(boolean decode) {
        if (decode) {
            return this.getPath();
        }
        return this.encodedPath;
    }

    @Override
    public List<PathSegment> getPathSegments() {
        return this.pathSegments;
    }

    @Override
    public List<PathSegment> getPathSegments(boolean decode) {
        if (decode) {
            return this.getPathSegments();
        }
        return this.encodedPathSegments;
    }

    @Override
    public URI getRequestUri() {
        if (this.requestURI == null) {
            this.requestURI = URI.create(this.absoluteString);
        }
        return this.requestURI;
    }

    @Override
    public UriBuilder getRequestUriBuilder() {
        return UriBuilder.fromUri(this.getRequestUri());
    }

    @Override
    public URI getAbsolutePath() {
        if (this.absolutePath == null) {
            this.absolutePath = this.queryIdx < 0 ? this.getRequestUri() : URI.create(this.absoluteString.substring(0, this.queryIdx));
        }
        return this.absolutePath;
    }

    @Override
    public UriBuilder getAbsolutePathBuilder() {
        return UriBuilder.fromUri(this.getAbsolutePath());
    }

    @Override
    public URI getBaseUri() {
        if (this.baseURI == null) {
            String tmpContextPath = this.contextPath;
            if (!tmpContextPath.endsWith("/")) {
                tmpContextPath = tmpContextPath + "/";
            }
            if (!tmpContextPath.startsWith("/")) {
                tmpContextPath = "/" + tmpContextPath;
            }
            String baseString = this.absoluteString.substring(0, this.pathStart);
            baseString = baseString + tmpContextPath;
            this.baseURI = URI.create(baseString);
        }
        return this.baseURI;
    }

    @Override
    public UriBuilder getBaseUriBuilder() {
        return UriBuilder.fromUri(this.getBaseUri());
    }

    @Override
    public MultivaluedMap<String, String> getPathParameters() {
        if (this.pathParameters == null) {
            this.pathParameters = new MultivaluedMapImpl<String, String>();
        }
        return this.pathParameters;
    }

    public void addEncodedPathParameter(String name, String value) {
        this.getEncodedPathParameters().add(name, value);
        String value1 = Encode.decodePath(value);
        this.getPathParameters().add(name, value1);
    }

    private MultivaluedMap<String, String> getEncodedPathParameters() {
        if (this.encodedPathParameters == null) {
            this.encodedPathParameters = new MultivaluedMapImpl<String, String>();
        }
        return this.encodedPathParameters;
    }

    public MultivaluedMap<String, PathSegment[]> getEncodedPathParameterPathSegments() {
        if (this.encodedPathParameterPathSegments == null) {
            this.encodedPathParameterPathSegments = new MultivaluedMapImpl<String, PathSegment[]>();
        }
        return this.encodedPathParameterPathSegments;
    }

    public MultivaluedMap<String, PathSegment[]> getPathParameterPathSegments() {
        if (this.pathParameterPathSegments == null) {
            this.pathParameterPathSegments = new MultivaluedMapImpl<String, PathSegment[]>();
        }
        return this.pathParameterPathSegments;
    }

    @Override
    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        if (decode) {
            return this.getPathParameters();
        }
        return this.getEncodedPathParameters();
    }

    @Override
    public MultivaluedMap<String, String> getQueryParameters() {
        if (this.queryParameters == null) {
            this.extractParameters();
        }
        return new UnmodifiableMultivaluedMap<String, String>(this.queryParameters);
    }

    protected MultivaluedMap<String, String> getEncodedQueryParameters() {
        if (this.encodedQueryParameters == null) {
            this.extractParameters();
        }
        return new UnmodifiableMultivaluedMap<String, String>(this.encodedQueryParameters);
    }

    @Override
    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        if (decode) {
            return this.getQueryParameters();
        }
        return this.getEncodedQueryParameters();
    }

    private void clearQueryParameters(boolean decode) {
        this.queryParameters = null;
        this.encodedQueryParameters = null;
    }

    protected void extractParameters() {
        String[] params;
        this.queryParameters = new MultivaluedMapImpl<String, String>();
        this.encodedQueryParameters = new MultivaluedMapImpl<String, String>();
        String queryString = this.getRequestUri().getRawQuery();
        if (queryString == null || queryString.equals("")) {
            return;
        }
        for (String param : params = queryString.split("&")) {
            if (param.indexOf(61) >= 0) {
                String[] nv = param.split("=", 2);
                try {
                    String name = URLDecoder.decode(nv[0], StandardCharsets.UTF_8.name());
                    String val = nv.length > 1 ? nv[1] : "";
                    this.encodedQueryParameters.add(name, val);
                    this.queryParameters.add(name, URLDecoder.decode(val, StandardCharsets.UTF_8.name()));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                String name = URLDecoder.decode(param, StandardCharsets.UTF_8.name());
                this.encodedQueryParameters.add(name, "");
                this.queryParameters.add(name, "");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public List<String> getMatchedURIs(boolean decode) {
        if (decode) {
            if (this.matchedUris == null) {
                if (this.encodedMatchedUris != null) {
                    this.matchedUris = new LinkedList<String>();
                    for (String match : this.encodedMatchedUris) {
                        String decoded = Encode.decode(match);
                        this.matchedUris.add(decoded);
                    }
                } else {
                    return Collections.emptyList();
                }
            }
            return Collections.unmodifiableList(this.matchedUris);
        }
        if (this.encodedMatchedUris == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.encodedMatchedUris);
    }

    @Override
    public List<String> getMatchedURIs() {
        return this.getMatchedURIs(true);
    }

    @Override
    public List<Object> getMatchedResources() {
        if (this.ancestors == null) {
            this.ancestors = new LinkedList<Object>();
        }
        return this.ancestors;
    }

    public void pushCurrentResource(Object resource) {
        if (this.ancestors == null) {
            this.ancestors = new LinkedList<Object>();
        }
        this.ancestors.add(0, resource);
    }

    public void pushMatchedPath(String encoded) {
        this.encodedMatchedPaths.add(0, encoded);
    }

    public List<String> getEncodedMatchedPaths() {
        return this.encodedMatchedPaths;
    }

    public void popMatchedPath() {
        this.encodedMatchedPaths.remove(0);
    }

    public void pushMatchedURI(String encoded) {
        int start = encoded.startsWith("/") ? 1 : 0;
        int end = encoded.endsWith("/") ? encoded.length() - 1 : encoded.length();
        String string = encoded = start < end ? encoded.substring(start, end) : "";
        if (this.encodedMatchedUris == null) {
            this.encodedMatchedUris = new LinkedList<String>();
        }
        this.encodedMatchedUris.add(0, encoded);
        this.matchedUris = null;
    }

    @Override
    public URI resolve(URI uri) {
        return this.getBaseUri().resolve(uri);
    }

    @Override
    public URI relativize(URI uri) {
        URI from = this.getRequestUri();
        URI to = uri;
        if (uri.getScheme() == null && uri.getHost() == null) {
            to = this.getBaseUriBuilder().replaceQuery(null).path(uri.getPath()).replaceQuery(uri.getQuery()).fragment(uri.getFragment()).build(new Object[0]);
        }
        return ResteasyUriBuilderImpl.relativize(from, to);
    }

    public static class InitData {
        private final int queryIdx;
        private final int pathStart;
        private final String encodedPath;
        private final String path;
        private final List<PathSegment> encodedPathSegments;
        private final List<PathSegment> pathSegments;
        private final String matchingPath;

        public InitData(String absoluteUri, String contextPath) {
            int tmp;
            int pathIdx = absoluteUri.indexOf(47);
            if (pathIdx > 0 && absoluteUri.length() > 3 && absoluteUri.charAt(pathIdx - 1) == ':' && absoluteUri.charAt(pathIdx + 1) == '/' && (tmp = absoluteUri.indexOf(47, pathIdx += 2)) > -1) {
                pathIdx = tmp;
            }
            this.queryIdx = pathIdx > -1 ? absoluteUri.indexOf(63, pathIdx) : absoluteUri.indexOf(63);
            int endPath = this.queryIdx > -1 ? this.queryIdx : absoluteUri.length();
            this.pathStart = pathIdx > -1 ? pathIdx : 0;
            String tmpEncodedPath = this.pathStart >= 0 && endPath > this.pathStart ? absoluteUri.substring(this.pathStart, endPath) : "";
            if ((tmpEncodedPath = PathHelper.getEncodedPathInfo(tmpEncodedPath, contextPath)).length() == 0 || tmpEncodedPath.charAt(0) != '/') {
                tmpEncodedPath = "/" + tmpEncodedPath;
            }
            this.encodedPath = tmpEncodedPath;
            this.path = Encode.decodePath(this.encodedPath);
            ProcessPathResult processPathResult = ResteasyUriInfo.doProcessPath(this.encodedPath);
            this.encodedPathSegments = processPathResult.getEncodedPathSegments();
            this.pathSegments = processPathResult.getPathSegments();
            this.matchingPath = processPathResult.getMatchingPath();
        }

        public int getQueryIdx() {
            return this.queryIdx;
        }

        public int getPathStart() {
            return this.pathStart;
        }

        public String getEncodedPath() {
            return this.encodedPath;
        }

        public String getPath() {
            return this.path;
        }

        public List<PathSegment> getEncodedPathSegments() {
            return this.encodedPathSegments;
        }

        public List<PathSegment> getPathSegments() {
            return this.pathSegments;
        }

        public String getMatchingPath() {
            return this.matchingPath;
        }

        public static boolean canBeCached(String absoluteUri) {
            return !absoluteUri.contains(";");
        }

        public static String getCacheKey(String absoluteUri, String contextPath) {
            int queryIdx = absoluteUri.lastIndexOf(63);
            return (queryIdx > -1 ? absoluteUri.substring(0, queryIdx) : absoluteUri) + "ResteasyUriInfo-Delimiter" + contextPath;
        }
    }

    private static class ProcessPathResult {
        private final List<PathSegment> encodedPathSegments;
        private final List<PathSegment> pathSegments;
        private final String matchingPath;

        private ProcessPathResult(List<PathSegment> encodedPathSegments, List<PathSegment> pathSegments, String matchingPath) {
            this.encodedPathSegments = encodedPathSegments;
            this.pathSegments = pathSegments;
            this.matchingPath = matchingPath;
        }

        public List<PathSegment> getEncodedPathSegments() {
            return this.encodedPathSegments;
        }

        public List<PathSegment> getPathSegments() {
            return this.pathSegments;
        }

        public String getMatchingPath() {
            return this.matchingPath;
        }
    }
}

