/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.EvalContext;
import io.quarkus.qute.Expression;
import io.quarkus.qute.Futures;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;

public final class EvaluatedParams {
    static final EvaluatedParams EMPTY;
    public final CompletionStage<?> stage;
    private final CompletableFuture<?>[] results;

    public static EvaluatedParams evaluate(EvalContext context) {
        List<Expression> params = context.getParams();
        if (params.isEmpty()) {
            return EMPTY;
        }
        if (params.size() == 1) {
            return new EvaluatedParams(context.evaluate(params.get(0)));
        }
        CompletableFuture[] allResults = new CompletableFuture[params.size()];
        LinkedList<CompletableFuture<Object>> results = null;
        int i = 0;
        for (Expression expression : params) {
            CompletableFuture<Object> result = context.evaluate(expression).toCompletableFuture();
            allResults[i++] = result;
            if (expression.isLiteral()) continue;
            if (results == null) {
                results = new LinkedList<CompletableFuture<Object>>();
            }
            results.add(result);
        }
        CompletionStage<Object> cs = results == null ? Futures.COMPLETED : (results.size() == 1 ? (CompletionStage)results.get(0) : CompletableFuture.allOf(results.toArray(new CompletableFuture[0])));
        return new EvaluatedParams(cs, allResults);
    }

    public static EvaluatedParams evaluateMessageKey(EvalContext context) {
        List<Expression> params = context.getParams();
        if (params.isEmpty()) {
            throw new IllegalArgumentException("No params to evaluate");
        }
        return new EvaluatedParams(context.evaluate(params.get(0)));
    }

    public static EvaluatedParams evaluateMessageParams(EvalContext context) {
        List<Expression> params = context.getParams();
        if (params.size() < 2) {
            return EMPTY;
        }
        CompletableFuture[] results = new CompletableFuture[params.size() - 1];
        int i = 0;
        Iterator<Expression> it = params.subList(1, params.size()).iterator();
        while (it.hasNext()) {
            results[i++] = context.evaluate(it.next()).toCompletableFuture();
        }
        return new EvaluatedParams(CompletableFuture.allOf(results), results);
    }

    EvaluatedParams(CompletionStage<?> stage) {
        this.stage = stage;
        this.results = new CompletableFuture[]{stage.toCompletableFuture()};
    }

    EvaluatedParams(CompletionStage<?> stage, CompletableFuture[] results) {
        this.stage = stage;
        this.results = results;
    }

    public Object getResult(int index) throws InterruptedException, ExecutionException {
        return this.results[index].get();
    }

    public boolean parameterTypesMatch(boolean varargs, Class<?>[] types) throws InterruptedException, ExecutionException {
        if (types.length == this.results.length) {
            if (varargs) {
                types[types.length - 1] = types[types.length - 1].getComponentType();
            }
        } else if (varargs) {
            int diff = types.length - this.results.length;
            if (diff > 1) {
                return false;
            }
            if (diff < 1) {
                Class<?> varargsType = types[types.length - 1];
                types[types.length - 1] = varargsType.getComponentType();
            }
        } else {
            return false;
        }
        int i = 0;
        Class<?> paramType = EvaluatedParams.boxType(types[i]);
        while (i < this.results.length) {
            Class<?> resultClass = EvaluatedParams.boxType(this.getResult(i).getClass());
            if (!paramType.isAssignableFrom(resultClass)) {
                return false;
            }
            if (types.length <= ++i) continue;
            paramType = EvaluatedParams.boxType(types[i]);
        }
        return true;
    }

    public Object getVarargsResults(int numberOfParameters, Class<?> componentType) throws InterruptedException, ExecutionException {
        int skip = numberOfParameters - 1;
        if (skip < 0) {
            return Array.newInstance(componentType, 0);
        }
        int idx = 0;
        Object array = Array.newInstance(componentType, this.results.length - skip);
        for (int i = skip; i < this.results.length; ++i) {
            Object result = this.getResult(i);
            Array.set(array, idx++, result);
        }
        return array;
    }

    private static Class<?> boxType(Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (type.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (type.equals(Character.TYPE)) {
            return Character.class;
        }
        if (type.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (type.equals(Short.TYPE)) {
            return Short.class;
        }
        if (type.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (type.equals(Long.TYPE)) {
            return Long.class;
        }
        if (type.equals(Float.TYPE)) {
            return Float.class;
        }
        if (type.equals(Double.TYPE)) {
            return Double.class;
        }
        if (type.equals(Void.TYPE)) {
            return Void.class;
        }
        throw new IllegalArgumentException();
    }

    static {
        CompletableFuture<Object> empty = new CompletableFuture<Object>();
        empty.complete(null);
        EMPTY = new EvaluatedParams(empty, new CompletableFuture[0]);
    }
}

