/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Expression;
import io.quarkus.qute.IfSectionHelper;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.Scope;
import io.quarkus.qute.SectionBlock;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.TemplateException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class WhenSectionHelper
implements SectionHelper {
    private static final String VALUE = "value";
    private static final String WHEN = "when";
    private static final String SWITCH = "switch";
    private static final String IS = "is";
    private static final String CASE = "case";
    private static final String ELSE = "else";
    private final Expression value;
    private final List<CaseBlock> caseBlocks;

    WhenSectionHelper(SectionHelperFactory.SectionInitContext context) {
        this.value = context.getExpression(VALUE);
        ImmutableList.Builder<CaseBlock> builder = ImmutableList.builder();
        block10: for (SectionBlock block : context.getBlocks()) {
            if ("$main".equals(block.label)) continue;
            switch (block.label) {
                case "is": 
                case "case": 
                case "else": {
                    builder.add(new CaseBlock(block, context));
                    continue block10;
                }
                case "$main": {
                    continue block10;
                }
            }
            throw new TemplateException("Invalid block: " + block);
        }
        this.caseBlocks = builder.build();
    }

    @Override
    public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
        return context.resolutionContext().evaluate(this.value).thenCompose(value -> {
            if (value != null && value.getClass().isEnum()) {
                return this.resolveEnumCaseBlocks(context, value, this.caseBlocks);
            }
            return this.resolveCaseBlocks(context, value, this.caseBlocks.iterator());
        });
    }

    CompletionStage<ResultNode> resolveCaseBlocks(SectionHelper.SectionResolutionContext context, Object value, Iterator<CaseBlock> caseBlocks) {
        CaseBlock caseBlock = caseBlocks.next();
        return caseBlock.resolve(context, value).thenCompose(r -> {
            if (r.booleanValue()) {
                return context.execute(caseBlock.block, context.resolutionContext());
            }
            if (caseBlocks.hasNext()) {
                return this.resolveCaseBlocks(context, value, caseBlocks);
            }
            return ResultNode.NOOP;
        });
    }

    CompletionStage<ResultNode> resolveEnumCaseBlocks(SectionHelper.SectionResolutionContext context, Object value, List<CaseBlock> caseBlocks) {
        for (CaseBlock caseBlock : caseBlocks) {
            if (!caseBlock.resolveEnum(context, value)) continue;
            return context.execute(caseBlock.block, context.resolutionContext());
        }
        return ResultNode.NOOP;
    }

    static class CaseBlock {
        private final SectionBlock block;
        private final CaseOperator caseOperator;
        private final List<Expression> params;

        public CaseBlock(SectionBlock block, SectionHelperFactory.SectionInitContext context) {
            this.block = block;
            this.caseOperator = CaseOperator.from(block.parameters.values());
            ImmutableList.Builder<Expression> builder = ImmutableList.builder();
            Iterator<String> iterator = block.parameters.values().iterator();
            if (block.parameters.size() > 1) {
                iterator.next();
            }
            while (iterator.hasNext()) {
                builder.add(context.parseValue(iterator.next()));
            }
            this.params = builder.build();
        }

        CompletionStage<Boolean> resolve(SectionHelper.SectionResolutionContext context, final Object value) {
            if (this.params.isEmpty()) {
                return CompletableFuture.completedFuture(true);
            }
            if (this.params.size() == 1) {
                Expression paramExpr = this.params.get(0);
                if (paramExpr.isLiteral()) {
                    try {
                        return CompletableFuture.completedFuture(this.caseOperator.evaluate(value, Collections.singletonList(paramExpr.getLiteralValue().get())));
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new IllegalStateException(e);
                    }
                }
                return context.resolutionContext().evaluate(paramExpr).thenApply(p -> this.caseOperator.evaluate(value, Collections.singletonList(p)));
            }
            final CompletableFuture[] allResults = new CompletableFuture[this.params.size()];
            LinkedList<CompletableFuture<Object>> results = new LinkedList<CompletableFuture<Object>>();
            int i = 0;
            for (Expression expression : this.params) {
                CompletableFuture<Object> result = context.resolutionContext().evaluate(expression).toCompletableFuture();
                allResults[i++] = result;
                if (expression.isLiteral()) continue;
                results.add(result);
            }
            if (results.isEmpty()) {
                return CompletableFuture.completedFuture(this.caseOperator.evaluate(value, Arrays.stream(allResults).map(t1 -> {
                    try {
                        return t1.get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new IllegalStateException(e);
                    }
                }).collect(Collectors.toList())));
            }
            return CompletableFuture.allOf(results.toArray(new CompletableFuture[0])).thenApply(new Function<Void, Boolean>(){

                @Override
                public Boolean apply(Void t) {
                    return caseOperator.evaluate(value, Arrays.stream(allResults).map(t1 -> {
                        try {
                            return t1.get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new IllegalStateException(e);
                        }
                    }).collect(Collectors.toList()));
                }
            });
        }

        boolean resolveEnum(SectionHelper.SectionResolutionContext context, Object value) {
            if (this.params.isEmpty()) {
                return true;
            }
            String enumValue = value.toString();
            if (this.params.size() == 1) {
                return this.caseOperator.evaluate(enumValue, Collections.singletonList(this.params.get(0).toOriginalString()));
            }
            ArrayList<String> paramValues = new ArrayList<String>(this.params.size());
            for (Expression param : this.params) {
                paramValues.add(param.toOriginalString());
            }
            return this.caseOperator.evaluate(enumValue, paramValues);
        }
    }

    static enum CaseOperator {
        EQ(new Predicate<Integer>(){

            @Override
            public boolean test(Integer params) {
                return params == 1;
            }
        }, new String[0]),
        NE("not", "ne", "!="),
        GT("gt", ">"),
        GE("ge", ">="),
        LE("le", "<="),
        LT("lt", "<"),
        IN(new Predicate<Integer>(){

            @Override
            public boolean test(Integer params) {
                return params >= 1;
            }
        }, "in"),
        NOT_IN(new Predicate<Integer>(){

            @Override
            public boolean test(Integer params) {
                return params >= 1;
            }
        }, "!in", "ni");

        final Predicate<Integer> params;
        final List<String> aliases;

        private CaseOperator(String ... aliases) {
            this(new Predicate<Integer>(){

                @Override
                public boolean test(Integer params) {
                    return params == 1;
                }
            }, aliases);
        }

        private CaseOperator(Predicate<Integer> paramsTest, String ... aliases) {
            this.params = paramsTest;
            this.aliases = Arrays.asList(aliases);
        }

        static CaseOperator from(Collection<String> blockParams) {
            if (blockParams.size() == 1) {
                return EQ;
            }
            if (blockParams.size() > 1) {
                Iterator<String> iterator = blockParams.iterator();
                String name = iterator.next();
                for (CaseOperator op : CaseOperator.values()) {
                    if (!op.params.test(blockParams.size() - 1)) continue;
                    for (String alias : op.aliases) {
                        if (!alias.equals(name)) continue;
                        return op;
                    }
                }
            }
            return null;
        }

        boolean evaluate(Object value, List<?> params) {
            switch (this) {
                case EQ: {
                    return Objects.equals(value, params.get(0));
                }
                case NE: {
                    return !Objects.equals(value, params.get(0));
                }
                case GE: 
                case GT: 
                case LE: 
                case LT: {
                    return this.compare(value, params.get(0));
                }
                case IN: {
                    return params.contains(value);
                }
                case NOT_IN: {
                    return !params.contains(value);
                }
            }
            throw new TemplateException("Not a legal operator: " + this);
        }

        boolean compare(Object op1, Object op2) {
            Comparable<BigDecimal> c2;
            Comparable<BigDecimal> c1;
            if (op1 == null || op2 == null) {
                throw new TemplateException("Unable to compare null operands [op1=" + op1 + ", op2=" + op2 + "]");
            }
            if (op1 instanceof Comparable && op1.getClass().equals(op2.getClass())) {
                c1 = (Comparable)op1;
                c2 = (Comparable)op2;
            } else {
                c1 = IfSectionHelper.Operator.getDecimal(op1);
                c2 = IfSectionHelper.Operator.getDecimal(op2);
            }
            int result = c1.compareTo((BigDecimal)c2);
            switch (this) {
                case GE: {
                    return result >= 0;
                }
                case GT: {
                    return result > 0;
                }
                case LE: {
                    return result <= 0;
                }
                case LT: {
                    return result < 0;
                }
            }
            return false;
        }
    }

    public static class Factory
    implements SectionHelperFactory<WhenSectionHelper> {
        public static final String HINT_PREFIX = "<when#";
        private static final String VALUE_EXPR_ID = "<<value-expr-id>>";

        @Override
        public List<String> getDefaultAliases() {
            return ImmutableList.of(WhenSectionHelper.WHEN, WhenSectionHelper.SWITCH);
        }

        @Override
        public SectionHelperFactory.ParametersInfo getParameters() {
            return SectionHelperFactory.ParametersInfo.builder().addParameter(WhenSectionHelper.VALUE).build();
        }

        @Override
        public WhenSectionHelper initialize(SectionHelperFactory.SectionInitContext context) {
            return new WhenSectionHelper(context);
        }

        @Override
        public List<String> getBlockLabels() {
            return ImmutableList.of(WhenSectionHelper.IS, WhenSectionHelper.CASE, WhenSectionHelper.ELSE);
        }

        @Override
        public Scope initializeBlock(Scope previousScope, SectionHelperFactory.BlockInfo block) {
            if (block.getLabel().equals("$main")) {
                String value = block.getParameters().get(WhenSectionHelper.VALUE);
                if (value == null) {
                    throw new IllegalStateException("Value param not present");
                }
                Expression valueExpr = block.addExpression(WhenSectionHelper.VALUE, value);
                if (valueExpr.hasTypeInfo()) {
                    previousScope.putAttribute(VALUE_EXPR_ID, valueExpr.getGeneratedId());
                }
            } else if (!WhenSectionHelper.ELSE.equals(block.getLabel())) {
                if (WhenSectionHelper.IS.equals(block.getLabel()) || WhenSectionHelper.CASE.equals(block.getLabel())) {
                    Object valueExprId = previousScope.getAttribute(VALUE_EXPR_ID);
                    int added = 0;
                    Iterator<String> it = block.getParameters().values().iterator();
                    while (it.hasNext()) {
                        String param = it.next();
                        if (added == 0 && it.hasNext()) continue;
                        ++added;
                        if (valueExprId != null) {
                            String previousBinding = previousScope.getBinding(param);
                            Object newBinding = previousBinding;
                            if (newBinding == null) {
                                newBinding = param;
                            }
                            newBinding = (String)newBinding + HINT_PREFIX + valueExprId + ">";
                            previousScope.putBinding(param, (String)newBinding);
                            block.addExpression(param, param);
                            previousScope.putBinding(param, previousBinding);
                            continue;
                        }
                        block.addExpression(param, param);
                    }
                } else {
                    throw block.createParserError("Invalid case block used in a {#when} section: " + block.getLabel());
                }
            }
            return previousScope;
        }
    }
}

