/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.common.constraint.Assert;
import io.smallrye.config.ConfigMappingGenerator;
import io.smallrye.config.ConfigMappingMetadata;
import java.lang.reflect.Modifier;

final class ConfigMappingClass
implements ConfigMappingMetadata {
    private static final ClassValue<ConfigMappingClass> cv = new ClassValue<ConfigMappingClass>(){

        @Override
        protected ConfigMappingClass computeValue(Class<?> classType) {
            return ConfigMappingClass.createConfigurationClass(classType);
        }
    };
    private final Class<?> classType;
    private final String interfaceName;

    static ConfigMappingClass getConfigurationClass(Class<?> classType) {
        Assert.checkNotNullParam("classType", classType);
        return cv.get(classType);
    }

    private static ConfigMappingClass createConfigurationClass(Class<?> classType) {
        if (classType.isInterface() && classType.getTypeParameters().length == 0 || Modifier.isAbstract(classType.getModifiers()) || classType.isEnum()) {
            return null;
        }
        return new ConfigMappingClass(classType);
    }

    public ConfigMappingClass(Class<?> classType) {
        this.classType = classType;
        this.interfaceName = ConfigMappingGenerator.generateInterfaceName(classType);
    }

    @Override
    public Class<?> getInterfaceType() {
        return this.classType;
    }

    @Override
    public String getClassName() {
        return this.interfaceName;
    }

    @Override
    public byte[] getClassBytes() {
        return ConfigMappingGenerator.generate(this.classType, this.interfaceName);
    }
}

