/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.netty.channel.EventLoop;
import io.vertx.core.Handler;
import io.vertx.core.impl.AbstractContext;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.WorkerPool;
import java.util.concurrent.RejectedExecutionException;

public class EventLoopContext
extends ContextImpl {
    EventLoopContext(VertxInternal vertx, EventLoop eventLoop, WorkerPool internalBlockingPool, WorkerPool workerPool, Deployment deployment, CloseFuture closeFuture, ClassLoader tccl) {
        super(vertx, eventLoop, internalBlockingPool, workerPool, deployment, closeFuture, tccl);
    }

    @Override
    void runOnContext(AbstractContext ctx, Handler<Void> action) {
        try {
            this.nettyEventLoop().execute(() -> ctx.dispatch(action));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <T> void emit(AbstractContext ctx, T argument, Handler<T> task) {
        EventLoop eventLoop = this.nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            ContextInternal prev = ctx.beginDispatch();
            try {
                task.handle(argument);
            }
            catch (Throwable t) {
                this.reportException(t);
            }
            finally {
                ctx.endDispatch(prev);
            }
        } else {
            eventLoop.execute(() -> this.emit(ctx, argument, task));
        }
    }

    @Override
    <T> void execute(AbstractContext ctx, T argument, Handler<T> task) {
        EventLoop eventLoop = this.nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            task.handle(argument);
        } else {
            eventLoop.execute(() -> task.handle(argument));
        }
    }

    @Override
    <T> void execute(AbstractContext ctx, Runnable task) {
        EventLoop eventLoop = this.nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            task.run();
        } else {
            eventLoop.execute(task);
        }
    }

    @Override
    public boolean isEventLoopContext() {
        return true;
    }

    @Override
    boolean inThread() {
        return this.nettyEventLoop().inEventLoop();
    }
}

