/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.jsonstructure;

import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.bind.JsonbException;
import javax.json.stream.JsonLocation;
import javax.json.stream.JsonParser;
import org.eclipse.yasson.internal.jsonstructure.JsonArrayIterator;
import org.eclipse.yasson.internal.jsonstructure.JsonObjectIterator;
import org.eclipse.yasson.internal.jsonstructure.JsonStructureIterator;

public class JsonStructureToParserAdapter
implements JsonParser {
    private Deque<JsonStructureIterator> iterators = new ArrayDeque<JsonStructureIterator>();
    private final JsonStructure rootStructure;

    public JsonStructureToParserAdapter(JsonStructure structure) {
        this.rootStructure = structure;
    }

    @Override
    public boolean hasNext() {
        return this.iterators.peek().hasNext();
    }

    @Override
    public JsonParser.Event next() {
        JsonStructureIterator current;
        JsonParser.Event next;
        if (this.iterators.isEmpty()) {
            if (this.rootStructure instanceof JsonObject) {
                this.iterators.push(new JsonObjectIterator((JsonObject)this.rootStructure));
                return JsonParser.Event.START_OBJECT;
            }
            if (this.rootStructure instanceof JsonArray) {
                this.iterators.push(new JsonArrayIterator((JsonArray)this.rootStructure));
                return JsonParser.Event.START_ARRAY;
            }
        }
        if ((next = (JsonParser.Event)((Object)(current = this.iterators.peek()).next())) == JsonParser.Event.START_OBJECT) {
            this.iterators.push(new JsonObjectIterator((JsonObject)this.iterators.peek().getValue()));
        } else if (next == JsonParser.Event.START_ARRAY) {
            this.iterators.push(new JsonArrayIterator((JsonArray)this.iterators.peek().getValue()));
        } else if (next == JsonParser.Event.END_OBJECT || next == JsonParser.Event.END_ARRAY) {
            this.iterators.pop();
        }
        return next;
    }

    @Override
    public String getString() {
        return this.iterators.peek().getString();
    }

    @Override
    public boolean isIntegralNumber() {
        return this.getJsonNumberValue().isIntegral();
    }

    @Override
    public int getInt() {
        return this.getJsonNumberValue().intValueExact();
    }

    @Override
    public long getLong() {
        return this.getJsonNumberValue().longValueExact();
    }

    @Override
    public BigDecimal getBigDecimal() {
        return this.getJsonNumberValue().bigDecimalValue();
    }

    private JsonNumber getJsonNumberValue() {
        JsonStructureIterator iterator = this.iterators.peek();
        JsonValue value = iterator.getValue();
        if (value.getValueType() != JsonValue.ValueType.NUMBER) {
            throw iterator.createIncompatibleValueError();
        }
        return (JsonNumber)value;
    }

    @Override
    public JsonLocation getLocation() {
        throw new JsonbException("Operation not supported");
    }

    @Override
    public void close() {
    }
}

