/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision.event;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.jackson.JsonFormat;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudEventUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CloudEventUtils.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModule((Module)JsonFormat.getCloudEventJacksonModule());

    public static <E> Optional<CloudEvent> build(String id, URI source, E data, Class<E> dataType) {
        try {
            byte[] bytes = OBJECT_MAPPER.writeValueAsBytes(data);
            return Optional.of(((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withType(dataType.getName()).withId(id).withSource(source).withData(bytes)).build());
        }
        catch (JsonProcessingException e) {
            LOG.error("Unable to serialize CloudEvent data", (Throwable)e);
            return Optional.empty();
        }
    }

    public static String encode(CloudEvent event) {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)event);
        }
        catch (JsonProcessingException e) {
            LOG.error("Unable to encode CloudEvent", (Throwable)e);
            return null;
        }
    }

    public static CloudEvent decode(String json) {
        try {
            return (CloudEvent)OBJECT_MAPPER.readValue(json, CloudEvent.class);
        }
        catch (JsonProcessingException e) {
            LOG.error("Unable to decode CloudEvent", (Throwable)e);
            return null;
        }
    }

    public static URI uriFromString(String input) {
        return URI.create(CloudEventUtils.urlEncode(input));
    }

    public static String urlEncode(String input) {
        try {
            return URLEncoder.encode(input, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private CloudEventUtils() {
    }
}

