/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision.event;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.tracing.decision.event.CloudEventUtils;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

class CloudEventUtilsTest {
    private static final String TEST_DATA = "this-is-some-test-data";
    private static final Class<String> TEST_DATA_CLASS = String.class;
    private static final String TEST_ID = "acacfa12-5520-419a-91c4-05a57676dd8b";
    private static final String TEST_URI_STRING = "http://test-host/test-endpoint";
    private static final URI TEST_URI = URI.create("http://test-host/test-endpoint");
    private static final CloudEvent TEST_CLOUDEVENT = ((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withType(TEST_DATA_CLASS.getName()).withId("acacfa12-5520-419a-91c4-05a57676dd8b").withSource(TEST_URI).withData(String.format("\"%s\"", "this-is-some-test-data").getBytes())).build();
    private static final String TEST_CORRECT_JSON = "{  \"specversion\":\"1.0\",  \"id\":\"acacfa12-5520-419a-91c4-05a57676dd8b\",  \"source\":\"http://test-host/test-endpoint\",  \"type\":\"" + TEST_DATA_CLASS.getName() + "\",  \"data\":\"" + "this-is-some-test-data" + "\"}";
    private static final String TEST_MALFORMED_JSON = "not-a-json-serialized-cloudevent";
    private static final String TEST_EXCEPTION_MESSAGE = "Mocked parse error";

    CloudEventUtilsTest() {
    }

    @Test
    void testBuildSuccess() {
        Assertions.assertTrue((boolean)CloudEventUtils.build((String)TEST_ID, (URI)TEST_URI, (Object)TEST_DATA, TEST_DATA_CLASS).isPresent());
    }

    @Test
    void testBuildFailure() throws Exception {
        CloudEventUtilsTest.runWithMockedCloudEventUtilsMapper(() -> Assertions.assertFalse((boolean)CloudEventUtils.build((String)TEST_ID, (URI)TEST_URI, (Object)TEST_DATA, TEST_DATA_CLASS).isPresent()));
    }

    @Test
    void testEncodeSuccess() {
        Assertions.assertTrue((boolean)CloudEventUtils.encode((CloudEvent)TEST_CLOUDEVENT).isPresent());
        System.out.println((String)CloudEventUtils.encode((CloudEvent)TEST_CLOUDEVENT).get());
    }

    @Test
    void testEncodeFailure() throws Exception {
        CloudEventUtilsTest.runWithMockedCloudEventUtilsMapper(() -> Assertions.assertFalse((boolean)CloudEventUtils.encode((CloudEvent)TEST_CLOUDEVENT).isPresent()));
    }

    @Test
    void testDecodeSuccess() {
        Assertions.assertTrue((boolean)CloudEventUtils.decode((String)TEST_CORRECT_JSON).isPresent());
    }

    @Test
    void testDecodeFailure() {
        Assertions.assertFalse((boolean)CloudEventUtils.decode((String)TEST_MALFORMED_JSON).isPresent());
    }

    @Test
    void testUrlEncodedStringFromSuccess() {
        Assertions.assertTrue((boolean)CloudEventUtils.urlEncodedStringFrom((String)TEST_URI_STRING).isPresent());
    }

    @Test
    void testUrlEncodedStringFromFailure() throws Exception {
        try (MockedStatic mockedStaticURLEncoder = Mockito.mockStatic(URLEncoder.class);){
            mockedStaticURLEncoder.when(() -> URLEncoder.encode((String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class))).thenThrow(new Throwable[]{new UnsupportedEncodingException()});
            Assertions.assertFalse((boolean)CloudEventUtils.urlEncodedStringFrom((String)TEST_URI_STRING).isPresent());
        }
    }

    @Test
    void testUrlEncodedURIFromSuccess() {
        Assertions.assertTrue((boolean)CloudEventUtils.urlEncodedURIFrom((String)TEST_URI_STRING).isPresent());
    }

    @Test
    void testUrlEncodedURIFromFailure() {
        try (MockedStatic mockedStaticURLEncoder = Mockito.mockStatic(URI.class);){
            mockedStaticURLEncoder.when(() -> URI.create((String)ArgumentMatchers.any(String.class))).thenThrow(new Throwable[]{new IllegalArgumentException()});
            Assertions.assertFalse((boolean)CloudEventUtils.urlEncodedURIFrom((String)TEST_URI_STRING).isPresent());
        }
    }

    private static ObjectMapper getFailingMockedObjectMapper() throws Exception {
        ObjectMapper mockedMapper = (ObjectMapper)Mockito.mock(ObjectMapper.class);
        Mockito.when((Object)mockedMapper.writeValueAsBytes(ArgumentMatchers.any())).thenThrow(new Throwable[]{new JsonProcessingException(TEST_EXCEPTION_MESSAGE){}});
        Mockito.when((Object)mockedMapper.writeValueAsString(ArgumentMatchers.any())).thenThrow(new Throwable[]{new JsonProcessingException(TEST_EXCEPTION_MESSAGE){}});
        return mockedMapper;
    }

    private static void runWithMockedCloudEventUtilsMapper(Runnable runnable) throws Exception {
        try (MockedStatic mockedStaticMapper = Mockito.mockStatic(CloudEventUtils.Mapper.class);){
            ObjectMapper mockedMapper = CloudEventUtilsTest.getFailingMockedObjectMapper();
            mockedStaticMapper.when(CloudEventUtils.Mapper::mapper).thenReturn((Object)mockedMapper);
            runnable.run();
        }
    }
}

