/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision;

import io.cloudevents.v1.CloudEventImpl;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.feel.util.Pair;
import org.kie.kogito.conf.ConfigBean;
import org.kie.kogito.conf.StaticConfigBean;
import org.kie.kogito.tracing.decision.DecisionTestUtils;
import org.kie.kogito.tracing.decision.DecisionTracingCollector;
import org.kie.kogito.tracing.decision.aggregator.Aggregator;
import org.kie.kogito.tracing.decision.event.CloudEventUtils;
import org.kie.kogito.tracing.decision.event.evaluate.EvaluateEvent;
import org.kie.kogito.tracing.decision.event.trace.TraceEvent;
import org.kie.kogito.tracing.decision.mock.MockDefaultAggregator;
import org.kie.kogito.tracing.decision.terminationdetector.BoundariesTerminationDetector;
import org.kie.kogito.tracing.decision.terminationdetector.CounterTerminationDetector;
import org.kie.kogito.tracing.decision.terminationdetector.TerminationDetector;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class DecisionTracingCollectorTest {
    private static DMNModel model;
    private static ConfigBean configBean;

    DecisionTracingCollectorTest() {
    }

    @BeforeAll
    static void initModel() {
        model = DecisionTestUtils.createDMNModel();
        configBean = new StaticConfigBean();
    }

    @Test
    void test_Collector_InterleavedEvaluations_BoundariesDetector_Working() {
        this.testInterleavedEvaluations(BoundariesTerminationDetector::new);
    }

    @Test
    void test_Collector_InterleavedEvaluations_CounterDetector_Working() {
        this.testInterleavedEvaluations(CounterTerminationDetector::new);
    }

    private void testInterleavedEvaluations(Supplier<TerminationDetector> terminationDetectorSupplier) {
        MockDefaultAggregator aggregator = new MockDefaultAggregator();
        Consumer payloadConsumer = (Consumer)Mockito.mock(Consumer.class);
        DecisionTracingCollector collector = new DecisionTracingCollector((Aggregator)aggregator, payloadConsumer, (namespace, name) -> model, terminationDetectorSupplier, configBean);
        List<EvaluateEvent> evaluateAllEvents = DecisionTestUtils.readEvaluateEventsFromJsonResource("/Traffic Violation_EvaluateEvents_evaluateAll.json");
        List<EvaluateEvent> evaluateDecisionServiceEvents = DecisionTestUtils.readEvaluateEventsFromJsonResource("/Traffic Violation_EvaluateEvents_evaluateDecisionService.json");
        for (int i = 0; i < Math.max(evaluateAllEvents.size(), evaluateDecisionServiceEvents.size()); ++i) {
            if (i < evaluateAllEvents.size()) {
                collector.addEvent(evaluateAllEvents.get(i));
            }
            if (i >= evaluateDecisionServiceEvents.size()) continue;
            collector.addEvent(evaluateDecisionServiceEvents.get(i));
        }
        Map<String, Pair<List<EvaluateEvent>, CloudEventImpl<TraceEvent>>> aggregatorCalls = aggregator.getCalls();
        Assertions.assertEquals((int)2, (int)aggregatorCalls.size());
        Assertions.assertTrue((boolean)aggregatorCalls.containsKey("4ac4c69f-4925-4221-b67e-4b14ce47bef8"));
        Assertions.assertEquals((int)evaluateAllEvents.size(), (int)((List)aggregatorCalls.get("4ac4c69f-4925-4221-b67e-4b14ce47bef8").getLeft()).size());
        Assertions.assertTrue((boolean)aggregatorCalls.containsKey("77408667-f218-40b0-a355-1bab047a3e9e"));
        Assertions.assertEquals((int)evaluateDecisionServiceEvents.size(), (int)((List)aggregatorCalls.get("77408667-f218-40b0-a355-1bab047a3e9e").getLeft()).size());
        ArgumentCaptor payloadCaptor = ArgumentCaptor.forClass(String.class);
        ((Consumer)Mockito.verify((Object)payloadConsumer, (VerificationMode)Mockito.times((int)2))).accept((String)payloadCaptor.capture());
        int evaluateAllIndex = evaluateAllEvents.size() > evaluateDecisionServiceEvents.size() ? 1 : 0;
        int evaluateDecisionServiceIndex = evaluateAllIndex == 1 ? 0 : 1;
        List payloads = payloadCaptor.getAllValues();
        Assertions.assertEquals((Object)CloudEventUtils.encode((CloudEventImpl)((CloudEventImpl)aggregatorCalls.get("4ac4c69f-4925-4221-b67e-4b14ce47bef8").getRight())), payloads.get(evaluateAllIndex));
        Assertions.assertEquals((Object)CloudEventUtils.encode((CloudEventImpl)((CloudEventImpl)aggregatorCalls.get("77408667-f218-40b0-a355-1bab047a3e9e").getRight())), payloads.get(evaluateDecisionServiceIndex));
    }
}

