/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.event.AfterEvaluateAllEvent;
import org.kie.dmn.api.core.event.BeforeEvaluateAllEvent;
import org.kie.dmn.api.core.event.DMNRuntimeEventListener;
import org.kie.dmn.core.impl.DMNContextImpl;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.impl.DMNResultImpl;
import org.kie.kogito.decision.DecisionExecutionIdUtils;
import org.kie.kogito.decision.DecisionModel;
import org.kie.kogito.dmn.DmnDecisionModel;
import org.kie.kogito.tracing.decision.DecisionTestUtils;
import org.kie.kogito.tracing.decision.DecisionTracingListener;
import org.kie.kogito.tracing.decision.event.evaluate.EvaluateEvent;
import org.kie.kogito.tracing.decision.event.evaluate.EvaluateEventType;
import org.kie.kogito.tracing.decision.mock.MockAfterEvaluateAllEvent;
import org.kie.kogito.tracing.decision.mock.MockBeforeEvaluateAllEvent;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class DecisionTracingListenerTest {
    static final String MOCKED_MODEL_NAME = "mockedModelName";
    static final String MOCKED_MODEL_NAMESPACE = "mockedModelNamespace";
    static final String TEST_EXECUTION_ID_1 = "e3140fbb-49fd-4835-bb2e-682bbe02d862";
    static final String TEST_EXECUTION_ID_2 = "77408667-f218-40b0-a355-1bab047a3e9e";

    DecisionTracingListenerTest() {
    }

    @Test
    void test_Listener_MockedEvents_Working() {
        DMNContextImpl context = new DMNContextImpl();
        DecisionExecutionIdUtils.inject((DMNContext)context, () -> TEST_EXECUTION_ID_1);
        DMNResultImpl result = new DMNResultImpl((DMNModel)new DMNModelImpl());
        result.setContext((DMNContext)context);
        MockBeforeEvaluateAllEvent beforeEvent = new MockBeforeEvaluateAllEvent(MOCKED_MODEL_NAMESPACE, MOCKED_MODEL_NAME, (DMNResult)result);
        MockAfterEvaluateAllEvent afterEvent = new MockAfterEvaluateAllEvent(MOCKED_MODEL_NAMESPACE, MOCKED_MODEL_NAME, (DMNResult)result);
        Consumer eventConsumer = (Consumer)Mockito.mock(Consumer.class);
        DecisionTracingListener listener = new DecisionTracingListener(eventConsumer);
        listener.beforeEvaluateAll((BeforeEvaluateAllEvent)beforeEvent);
        listener.afterEvaluateAll((AfterEvaluateAllEvent)afterEvent);
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(EvaluateEvent.class);
        ((Consumer)Mockito.verify((Object)eventConsumer, (VerificationMode)Mockito.times((int)2))).accept((EvaluateEvent)eventCaptor.capture());
        DecisionTracingListenerTest.assertEvaluateAllEvents(eventCaptor.getAllValues(), MOCKED_MODEL_NAMESPACE, MOCKED_MODEL_NAME, TEST_EXECUTION_ID_1);
    }

    @Test
    void test_Listener_RealEvaluateAll_Working() {
        DecisionTracingListenerTest.testWithRealEvaluateAll(DecisionTestUtils.getEvaluateAllContext(), 14);
    }

    @Test
    void test_Listener_RealEvaluateAllWithWarnMessage_Working() {
        DecisionTracingListenerTest.testWithRealEvaluateAll(DecisionTestUtils.getEvaluateAllContextForWarning(), 14);
    }

    @Test
    void test_Listener_RealEvaluateAllWithErrorMessage_Working() {
        DecisionTracingListenerTest.testWithRealEvaluateAll(DecisionTestUtils.getEvaluateAllContextForError(), 10);
    }

    @Test
    void test_Listener_RealEvaluateDecisionService_Working() {
        DecisionTracingListenerTest.testWithRealEvaluateDecisionService(DecisionTestUtils.getEvaluateDecisionServiceContext(), 6);
    }

    @Test
    void test_Listener_RealEvaluateDecisionServiceWithWarnMessage_Working() {
        DecisionTracingListenerTest.testWithRealEvaluateDecisionService(DecisionTestUtils.getEvaluateDecisionServiceContextForWarning(), 6);
    }

    @Test
    void test_Listener_RealEvaluateDecisionServiceWithEmptyContext_Working() {
        HashMap<String, Object> contextVariables = new HashMap<String, Object>();
        DecisionTracingListenerTest.testWithRealEvaluateDecisionService(contextVariables, 6);
    }

    private static void testWithRealEvaluateAll(Map<String, Object> contextVariables, int expectedEvents) {
        List<EvaluateEvent> events = DecisionTracingListenerTest.testWithRealRuntime(contextVariables, expectedEvents, DecisionModel::evaluateAll);
        DecisionTracingListenerTest.assertEvaluateAllEvents(events, "https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", "Traffic Violation", TEST_EXECUTION_ID_2);
    }

    private static void testWithRealEvaluateDecisionService(Map<String, Object> contextVariables, int expectedEvents) {
        List<EvaluateEvent> events = DecisionTracingListenerTest.testWithRealRuntime(contextVariables, expectedEvents, (model, context) -> model.evaluateDecisionService(context, "FineService"));
        DecisionTracingListenerTest.assertEvaluateDecisionServiceEvents(events, "https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", "Traffic Violation", TEST_EXECUTION_ID_2);
    }

    private static List<EvaluateEvent> testWithRealRuntime(Map<String, Object> contextVariables, int expectedEvents, BiConsumer<DecisionModel, DMNContext> modelConsumer) {
        DMNRuntime runtime = DecisionTestUtils.createDMNRuntime();
        Consumer eventConsumer = (Consumer)Mockito.mock(Consumer.class);
        DecisionTracingListener listener = new DecisionTracingListener(eventConsumer);
        runtime.addListener((DMNRuntimeEventListener)listener);
        DmnDecisionModel model = new DmnDecisionModel(runtime, "https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", "Traffic Violation", () -> TEST_EXECUTION_ID_2);
        DMNContext context = model.newContext(contextVariables);
        modelConsumer.accept((DecisionModel)model, context);
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(EvaluateEvent.class);
        ((Consumer)Mockito.verify((Object)eventConsumer, (VerificationMode)Mockito.times((int)expectedEvents))).accept((EvaluateEvent)eventCaptor.capture());
        return eventCaptor.getAllValues();
    }

    private static void assertEvaluateAllEvents(List<EvaluateEvent> evaluateEvents, String modelNamespace, String modelName, String executionId) {
        Assertions.assertTrue((evaluateEvents.size() >= 2 ? 1 : 0) != 0);
        evaluateEvents.forEach(e -> DecisionTracingListenerTest.assertEventMatches(modelNamespace, modelName, executionId, e));
        EvaluateEvent beforeEvent = evaluateEvents.get(0);
        Assertions.assertSame((Object)EvaluateEventType.BEFORE_EVALUATE_ALL, (Object)beforeEvent.getType());
        EvaluateEvent afterEvent = evaluateEvents.get(evaluateEvents.size() - 1);
        Assertions.assertSame((Object)EvaluateEventType.AFTER_EVALUATE_ALL, (Object)afterEvent.getType());
    }

    private static void assertEvaluateDecisionServiceEvents(List<EvaluateEvent> evaluateEvents, String modelNamespace, String modelName, String executionId) {
        Assertions.assertTrue((evaluateEvents.size() >= 2 ? 1 : 0) != 0);
        evaluateEvents.forEach(e -> DecisionTracingListenerTest.assertEventMatches(modelNamespace, modelName, executionId, e));
        EvaluateEvent beforeEvent = evaluateEvents.get(0);
        Assertions.assertSame((Object)EvaluateEventType.BEFORE_EVALUATE_DECISION_SERVICE, (Object)beforeEvent.getType());
        Assertions.assertEquals((Object)"_073E3815-F30F-4835-A5CF-A9B354444E09", (Object)beforeEvent.getNodeId());
        Assertions.assertEquals((Object)"FineService", (Object)beforeEvent.getNodeName());
        EvaluateEvent afterEvent = evaluateEvents.get(evaluateEvents.size() - 1);
        Assertions.assertSame((Object)EvaluateEventType.AFTER_EVALUATE_DECISION_SERVICE, (Object)afterEvent.getType());
        Assertions.assertEquals((Object)"_073E3815-F30F-4835-A5CF-A9B354444E09", (Object)afterEvent.getNodeId());
        Assertions.assertEquals((Object)"FineService", (Object)afterEvent.getNodeName());
    }

    private static void assertEventMatches(String modelNamespace, String modelName, String executionId, EvaluateEvent event) {
        Assertions.assertTrue((event.getModelNamespace() == null && event.getModelName() == null || event.getModelNamespace() != null && event.getModelName() != null ? 1 : 0) != 0);
        if (event.getModelNamespace() != null) {
            Assertions.assertEquals((Object)modelNamespace, (Object)event.getModelNamespace());
            Assertions.assertEquals((Object)modelName, (Object)event.getModelName());
        }
        Assertions.assertEquals((Object)executionId, (Object)event.getExecutionId());
    }
}

