/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision.event;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.kie.api.builder.Message;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.kogito.tracing.decision.event.message.InternalMessageType;
import org.kie.kogito.tracing.decision.event.message.Message;
import org.kie.kogito.tracing.decision.event.message.MessageCategory;
import org.kie.kogito.tracing.decision.event.message.MessageExceptionField;
import org.kie.kogito.tracing.decision.event.message.MessageFEELEvent;
import org.kie.kogito.tracing.decision.event.message.MessageFEELEventSeverity;
import org.kie.kogito.tracing.decision.event.message.MessageLevel;
import org.kie.kogito.tracing.decision.event.trace.TraceResourceId;
import org.kie.kogito.tracing.typedvalue.CollectionValue;
import org.kie.kogito.tracing.typedvalue.StructureValue;
import org.kie.kogito.tracing.typedvalue.TypedValue;
import org.kie.kogito.tracing.typedvalue.UnitValue;

public class EventUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static JsonNode jsonNodeFrom(Object object) {
        return Optional.ofNullable(object).map(arg_0 -> ((ObjectMapper)OBJECT_MAPPER).valueToTree(arg_0)).orElse(null);
    }

    public static <I, O> List<O> map(List<I> input, Function<I, O> mapper) {
        return input == null ? null : input.stream().map(mapper).collect(Collectors.toList());
    }

    public static Message messageFrom(DMNMessage message) {
        if (message == null) {
            return null;
        }
        return new Message(EventUtils.messageLevelFrom(message.getLevel()), MessageCategory.DMN, message.getMessageType().name(), message.getSourceId(), message.getText(), EventUtils.messageFEELEventFrom(message.getFeelEvent()), EventUtils.messageExceptionFieldFrom(message.getException()));
    }

    public static Message messageFrom(InternalMessageType message) {
        if (message == null) {
            return null;
        }
        return new Message(message.getLevel(), MessageCategory.INTERNAL, message.name(), null, message.getText(), null, null);
    }

    public static Message messageFrom(InternalMessageType message, Throwable throwable) {
        if (message == null) {
            return null;
        }
        return new Message(message.getLevel(), MessageCategory.INTERNAL, message.name(), null, message.getText(), null, EventUtils.messageExceptionFieldFrom(throwable));
    }

    public static MessageExceptionField messageExceptionFieldFrom(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        return new MessageExceptionField(throwable.getClass().getName(), throwable.getMessage(), EventUtils.messageExceptionFieldFrom(throwable.getCause()));
    }

    public static MessageFEELEvent messageFEELEventFrom(FEELEvent feelEvent) {
        if (feelEvent == null) {
            return null;
        }
        return new MessageFEELEvent(EventUtils.messageFEELEventSeverityFrom(feelEvent.getSeverity()), feelEvent.getMessage(), Integer.valueOf(feelEvent.getLine()), Integer.valueOf(feelEvent.getColumn()), EventUtils.messageExceptionFieldFrom(feelEvent.getSourceException()));
    }

    public static MessageFEELEventSeverity messageFEELEventSeverityFrom(FEELEvent.Severity severity) {
        if (severity == null) {
            return null;
        }
        switch (severity) {
            case TRACE: {
                return MessageFEELEventSeverity.TRACE;
            }
            case INFO: {
                return MessageFEELEventSeverity.INFO;
            }
            case WARN: {
                return MessageFEELEventSeverity.WARN;
            }
            case ERROR: {
                return MessageFEELEventSeverity.ERROR;
            }
        }
        throw new IllegalArgumentException(String.format("Can't convert FEELEvent.Severity.%s to MessageFEELEventSeverity", severity.name()));
    }

    public static MessageLevel messageLevelFrom(Message.Level level) {
        if (level == null) {
            return null;
        }
        switch (level) {
            case ERROR: {
                return MessageLevel.ERROR;
            }
            case WARNING: {
                return MessageLevel.WARNING;
            }
            case INFO: {
                return MessageLevel.INFO;
            }
        }
        throw new IllegalArgumentException(String.format("Can't convert Message.Level.%s to MessageLevel", level.name()));
    }

    public static <T> Stream<T> streamFrom(Iterator<T> iterator) {
        Iterable iterable = () -> iterator;
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static TraceResourceId traceResourceIdFrom(String serviceUrl, DMNModel model) {
        if (model == null) {
            return null;
        }
        return new TraceResourceId(serviceUrl, model.getNamespace(), model.getName());
    }

    public static TypedValue typedValueFrom(Object value) {
        return EventUtils.typedValueFromJsonNode(EventUtils.jsonNodeFrom(value), BuiltInType.determineTypeFromInstance((Object)value));
    }

    public static TypedValue typedValueFrom(DMNType type, Object value) {
        return EventUtils.typedValueFromJsonNode(type, EventUtils.jsonNodeFrom(value), BuiltInType.determineTypeFromInstance((Object)value));
    }

    static TypedValue typedValueFromJsonNode(JsonNode value, Type suggestedType) {
        if (value != null && value.isObject()) {
            return new StructureValue(EventUtils.typeOf(value).getName(), (Map)EventUtils.streamFrom(value.fields()).collect(HashMap::new, (map, entry) -> map.put((String)entry.getKey(), EventUtils.typedValueFromJsonNode((JsonNode)entry.getValue(), null)), HashMap::putAll));
        }
        if (value != null && value.isArray()) {
            return new CollectionValue(EventUtils.typeOf(value).getName(), (Collection)EventUtils.streamFrom(value.elements()).map(v -> EventUtils.typedValueFromJsonNode(v, null)).collect(Collectors.toList()));
        }
        Type finalType = Optional.ofNullable(suggestedType).orElseGet(() -> EventUtils.typeOf(value));
        return new UnitValue(finalType.getName(), value);
    }

    static TypedValue typedValueFromJsonNode(DMNType type, JsonNode value, Type suggestedType) {
        if (type == null) {
            return EventUtils.typedValueFromJsonNode(value, suggestedType);
        }
        if (value != null && value.isObject()) {
            return new StructureValue(type.getName(), (Map)EventUtils.streamFrom(value.fields()).collect(HashMap::new, (map, entry) -> map.put((String)entry.getKey(), EventUtils.typedValueFromJsonNode((DMNType)type.getFields().get(entry.getKey()), (JsonNode)entry.getValue(), null)), HashMap::putAll));
        }
        if (value != null && value.isArray()) {
            return new CollectionValue(type.getName(), (Collection)EventUtils.streamFrom(value.elements()).map(element -> EventUtils.typedValueFromJsonNode(type, element, null)).collect(Collectors.toList()));
        }
        return new UnitValue(type.getName(), EventUtils.baseTypeOf(type), value);
    }

    static String baseTypeOf(DMNType type) {
        if (type == null || type.getBaseType() == null) {
            return null;
        }
        return type.getBaseType().getId() == null ? type.getBaseType().getName() : EventUtils.baseTypeOf(type.getBaseType());
    }

    static Type typeOf(JsonNode value) {
        if (value == null) {
            return BuiltInType.UNKNOWN;
        }
        if (value.isArray()) {
            return BuiltInType.LIST;
        }
        if (value.isBoolean()) {
            return BuiltInType.BOOLEAN;
        }
        if (value.isNumber()) {
            return BuiltInType.NUMBER;
        }
        if (value.isTextual()) {
            return BuiltInType.STRING;
        }
        return BuiltInType.UNKNOWN;
    }

    private EventUtils() {
    }
}

