/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.validator.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.arc.runtime.BeanContainerListener;
import io.quarkus.hibernate.validator.runtime.ArcConstraintValidatorFactoryImpl;
import io.quarkus.hibernate.validator.runtime.ArcProxyBeanMetaDataClassNormalizer;
import io.quarkus.hibernate.validator.runtime.HibernateValidatorBuildTimeConfig;
import io.quarkus.hibernate.validator.runtime.TraverseAllTraversableResolver;
import io.quarkus.hibernate.validator.runtime.ValidatorHolder;
import io.quarkus.hibernate.validator.runtime.jaxrs.ResteasyConfigSupport;
import io.quarkus.runtime.LocalesBuildTimeConfig;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.ClockProvider;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.ParameterNameProvider;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import javax.validation.valueextraction.ValueExtractor;
import org.hibernate.validator.PredefinedScopeHibernateValidator;
import org.hibernate.validator.PredefinedScopeHibernateValidatorConfiguration;
import org.hibernate.validator.internal.engine.resolver.JPATraversableResolver;
import org.hibernate.validator.spi.messageinterpolation.LocaleResolver;
import org.hibernate.validator.spi.nodenameprovider.PropertyNodeNameProvider;
import org.hibernate.validator.spi.properties.GetterPropertySelectionStrategy;
import org.hibernate.validator.spi.scripting.ScriptEvaluatorFactory;

@Recorder
public class HibernateValidatorRecorder {
    public BeanContainerListener initializeValidatorFactory(final Set<Class<?>> classesToBeValidated, final Set<String> detectedBuiltinConstraints, final boolean hasXmlConfiguration, final boolean jpaInClasspath, final ShutdownContext shutdownContext, final LocalesBuildTimeConfig localesBuildTimeConfig, final HibernateValidatorBuildTimeConfig hibernateValidatorBuildTimeConfig) {
        BeanContainerListener beanContainerListener = new BeanContainerListener(){

            @Override
            public void created(BeanContainer container) {
                InstanceHandle<PropertyNodeNameProvider> configuredPropertyNodeNameProvider;
                InstanceHandle<GetterPropertySelectionStrategy> configuredGetterPropertySelectionStrategy;
                InstanceHandle<ClockProvider> configuredClockProvider;
                InstanceHandle<TraversableResolver> configuredTraversableResolver;
                PredefinedScopeHibernateValidatorConfiguration configuration = (PredefinedScopeHibernateValidatorConfiguration)Validation.byProvider(PredefinedScopeHibernateValidator.class).configure();
                if (!hasXmlConfiguration) {
                    configuration.ignoreXmlConfiguration();
                }
                LocaleResolver localeResolver = null;
                InstanceHandle<LocaleResolver> configuredLocaleResolver = Arc.container().instance(LocaleResolver.class, new Annotation[0]);
                if (configuredLocaleResolver.isAvailable()) {
                    localeResolver = configuredLocaleResolver.get();
                    configuration.localeResolver(localeResolver);
                }
                ((PredefinedScopeHibernateValidatorConfiguration)((PredefinedScopeHibernateValidatorConfiguration)configuration.builtinConstraints(detectedBuiltinConstraints).initializeBeanMetaData(classesToBeValidated).locales(localesBuildTimeConfig.locales)).defaultLocale(localesBuildTimeConfig.defaultLocale)).beanMetaDataClassNormalizer(new ArcProxyBeanMetaDataClassNormalizer());
                InstanceHandle<ConstraintValidatorFactory> configuredConstraintValidatorFactory = Arc.container().instance(ConstraintValidatorFactory.class, new Annotation[0]);
                if (configuredConstraintValidatorFactory.isAvailable()) {
                    configuration.constraintValidatorFactory(configuredConstraintValidatorFactory.get());
                } else {
                    configuration.constraintValidatorFactory(new ArcConstraintValidatorFactoryImpl());
                }
                InstanceHandle<MessageInterpolator> configuredMessageInterpolator = Arc.container().instance(MessageInterpolator.class, new Annotation[0]);
                if (configuredMessageInterpolator.isAvailable()) {
                    configuration.messageInterpolator(configuredMessageInterpolator.get());
                }
                if ((configuredTraversableResolver = Arc.container().instance(TraversableResolver.class, new Annotation[0])).isAvailable()) {
                    configuration.traversableResolver(configuredTraversableResolver.get());
                } else if (jpaInClasspath) {
                    configuration.traversableResolver(new JPATraversableResolver());
                } else {
                    configuration.traversableResolver(new TraverseAllTraversableResolver());
                }
                InstanceHandle<ParameterNameProvider> configuredParameterNameProvider = Arc.container().instance(ParameterNameProvider.class, new Annotation[0]);
                if (configuredParameterNameProvider.isAvailable()) {
                    configuration.parameterNameProvider(configuredParameterNameProvider.get());
                }
                if ((configuredClockProvider = Arc.container().instance(ClockProvider.class, new Annotation[0])).isAvailable()) {
                    configuration.clockProvider(configuredClockProvider.get());
                }
                configuration.failFast(hibernateValidatorBuildTimeConfig.failFast);
                configuration.allowOverridingMethodAlterParameterConstraint(hibernateValidatorBuildTimeConfig.methodValidation.allowOverridingParameterConstraints);
                configuration.allowParallelMethodsDefineParameterConstraints(hibernateValidatorBuildTimeConfig.methodValidation.allowParameterConstraintsOnParallelMethods);
                configuration.allowMultipleCascadedValidationOnReturnValues(hibernateValidatorBuildTimeConfig.methodValidation.allowMultipleCascadedValidationOnReturnValues);
                InstanceHandle<ScriptEvaluatorFactory> configuredScriptEvaluatorFactory = Arc.container().instance(ScriptEvaluatorFactory.class, new Annotation[0]);
                if (configuredScriptEvaluatorFactory.isAvailable()) {
                    configuration.scriptEvaluatorFactory(configuredScriptEvaluatorFactory.get());
                }
                if ((configuredGetterPropertySelectionStrategy = Arc.container().instance(GetterPropertySelectionStrategy.class, new Annotation[0])).isAvailable()) {
                    configuration.getterPropertySelectionStrategy(configuredGetterPropertySelectionStrategy.get());
                }
                if ((configuredPropertyNodeNameProvider = Arc.container().instance(PropertyNodeNameProvider.class, new Annotation[0])).isAvailable()) {
                    configuration.propertyNodeNameProvider(configuredPropertyNodeNameProvider.get());
                }
                for (ValueExtractor valueExtractor : Arc.container().beanManager().createInstance().select(ValueExtractor.class, new Annotation[0])) {
                    configuration.addValueExtractor(valueExtractor);
                }
                final ValidatorFactory validatorFactory = configuration.buildValidatorFactory();
                ValidatorHolder.initialize(validatorFactory);
                shutdownContext.addShutdownTask(new Runnable(){

                    @Override
                    public void run() {
                        validatorFactory.close();
                    }
                });
            }
        };
        return beanContainerListener;
    }

    public Supplier<ResteasyConfigSupport> resteasyConfigSupportSupplier(final boolean jsonDefault) {
        return new Supplier<ResteasyConfigSupport>(){

            @Override
            public ResteasyConfigSupport get() {
                return new ResteasyConfigSupport(jsonDefault);
            }
        };
    }
}

