/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.validator.runtime.jaxrs;

import java.util.ArrayList;
import java.util.List;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class QuarkusRestViolationExceptionMapper
implements ExceptionMapper<ValidationException> {
    @Override
    public Response toResponse(ValidationException exception) {
        if (exception instanceof ConstraintViolationException) {
            return this.buildConstrainViolationResponse((ConstraintViolationException)exception);
        }
        return this.buildResponse(this.unwrapException(exception), Response.Status.INTERNAL_SERVER_ERROR);
    }

    protected Response buildResponse(Object entity, Response.Status status) {
        return Response.status(status).entity(entity).build();
    }

    protected String unwrapException(Throwable t) {
        StringBuffer sb = new StringBuffer();
        this.doUnwrapException(sb, t);
        return sb.toString();
    }

    private void doUnwrapException(StringBuffer sb, Throwable t) {
        if (t == null) {
            return;
        }
        sb.append(t.toString());
        if (t.getCause() != null && t != t.getCause()) {
            sb.append('[');
            this.doUnwrapException(sb, t.getCause());
            sb.append(']');
        }
    }

    private Response buildConstrainViolationResponse(ConstraintViolationException cve) {
        boolean hasReturnValueViolation = false;
        ArrayList<ViolationReport.Violation> violationsInReport = new ArrayList<ViolationReport.Violation>(cve.getConstraintViolations().size());
        for (ConstraintViolation<?> cv : cve.getConstraintViolations()) {
            if (cv.getExecutableReturnValue() != null) {
                hasReturnValueViolation = true;
            }
            violationsInReport.add(new ViolationReport.Violation(cv.getPropertyPath().toString(), cv.getMessage()));
        }
        Response.Status status = hasReturnValueViolation ? Response.Status.INTERNAL_SERVER_ERROR : Response.Status.BAD_REQUEST;
        return this.buildResponse(new ViolationReport("Constraint Violation", status, violationsInReport), status);
    }

    public static class ViolationReport {
        private final String title;
        private final int status;
        private final List<Violation> violations;

        public ViolationReport(String title, Response.Status status, List<Violation> violations) {
            this.title = title;
            this.status = status.getStatusCode();
            this.violations = violations;
        }

        public String getTitle() {
            return this.title;
        }

        public int getStatus() {
            return this.status;
        }

        public List<Violation> getViolations() {
            return this.violations;
        }

        public static class Violation {
            private final String field;
            private final String message;

            public Violation(String field, String message) {
                this.field = field;
                this.message = message;
            }

            public String getField() {
                return this.field;
            }

            public String getMessage() {
                return this.message;
            }
        }
    }
}

