/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.devmode;

import io.quarkus.dev.ErrorPageGenerators;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.dev.spi.HotReplacementContext;
import io.quarkus.dev.spi.HotReplacementSetup;
import io.quarkus.vertx.http.runtime.VertxHttpRecorder;
import io.quarkus.vertx.http.runtime.devmode.RemoteSyncHandler;
import io.quarkus.vertx.http.runtime.devmode.ReplacementDebugPage;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.LogManager;

public class VertxHttpHotReplacementSetup
implements HotReplacementSetup {
    private volatile long nextUpdate;
    private HotReplacementContext hotReplacementContext;
    private static final long HOT_REPLACEMENT_INTERVAL = 2000L;
    private static final String HEADER_NAME = "x-quarkus-hot-deployment-done";
    private static volatile Set<ConnectionBase> openConnections;

    @Override
    public void setupHotDeployment(HotReplacementContext context) {
        System.setProperty("vertxweb.environment", "dev");
        this.hotReplacementContext = context;
        VertxHttpRecorder.setHotReplacement(this::handleHotReplacementRequest, this.hotReplacementContext);
        this.hotReplacementContext.addPreScanStep(new Runnable(){

            @Override
            public void run() {
                RemoteSyncHandler.doPreScan();
            }
        });
    }

    @Override
    public void handleFailedInitialStart() {
        LogManager.getLogManager().getLogger("io.vertx.core.impl.ContextImpl").setLevel(Level.SEVERE);
        VertxHttpRecorder.startServerAfterFailedStart();
    }

    public static void handleDevModeRestart() {
        if (DevConsoleManager.isDoingHttpInitiatedReload()) {
            return;
        }
        Set<ConnectionBase> cons = openConnections;
        if (cons != null) {
            for (ConnectionBase con : cons) {
                con.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void handleHotReplacementRequest(final RoutingContext routingContext) {
        ConnectionBase connectionBase;
        if (openConnections == null) {
            Class<VertxHttpHotReplacementSetup> clazz = VertxHttpHotReplacementSetup.class;
            // MONITORENTER : io.quarkus.vertx.http.runtime.devmode.VertxHttpHotReplacementSetup.class
            if (openConnections == null) {
                openConnections = Collections.newSetFromMap(new ConcurrentHashMap());
            }
            // MONITOREXIT : clazz
        }
        if (openConnections.add(connectionBase = (ConnectionBase)((Object)routingContext.request().connection()))) {
            connectionBase.closeFuture().onComplete(new Handler<AsyncResult<Void>>(){

                @Override
                public void handle(AsyncResult<Void> event) {
                    openConnections.remove(connectionBase);
                }
            });
        }
        if ((this.nextUpdate <= System.currentTimeMillis() || this.hotReplacementContext.isTest()) && !routingContext.request().headers().contains(HEADER_NAME)) {
            final ClassLoader current = Thread.currentThread().getContextClassLoader();
            connectionBase.getContext().executeBlocking(new Handler<Promise<Boolean>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void handle(Promise<Boolean> event) {
                    Thread.currentThread().setContextClassLoader(current);
                    boolean restart = false;
                    try {
                        DevConsoleManager.setDoingHttpInitiatedReload(true);
                        3 var3_3 = this;
                        // MONITORENTER : var3_3
                        if (VertxHttpHotReplacementSetup.this.nextUpdate < System.currentTimeMillis() || VertxHttpHotReplacementSetup.this.hotReplacementContext.isTest()) {
                            VertxHttpHotReplacementSetup.this.nextUpdate = System.currentTimeMillis() + 2000L;
                            try {
                                restart = VertxHttpHotReplacementSetup.this.hotReplacementContext.doScan(true);
                            }
                            catch (Exception e) {
                                event.fail(new IllegalStateException("Unable to perform live reload scanning", e));
                                // MONITOREXIT : var3_3
                                DevConsoleManager.setDoingHttpInitiatedReload(false);
                                return;
                            }
                        }
                        // MONITOREXIT : var3_3
                        if (VertxHttpHotReplacementSetup.this.hotReplacementContext.getDeploymentProblem() != null) {
                            event.fail(VertxHttpHotReplacementSetup.this.hotReplacementContext.getDeploymentProblem());
                            return;
                        }
                        if (restart) {
                            HashSet<ConnectionBase> connections = new HashSet<ConnectionBase>(openConnections);
                            for (ConnectionBase con : connections) {
                                if (con == connectionBase) continue;
                                con.close();
                            }
                        }
                    }
                    finally {
                        DevConsoleManager.setDoingHttpInitiatedReload(false);
                    }
                    event.complete(restart);
                }
            }, false, new Handler<AsyncResult<Boolean>>(){

                @Override
                public void handle(AsyncResult<Boolean> event) {
                    if (event.failed()) {
                        VertxHttpHotReplacementSetup.handleDeploymentProblem(routingContext, event.cause());
                    } else {
                        boolean restart = event.result();
                        if (restart) {
                            routingContext.request().headers().set(VertxHttpHotReplacementSetup.HEADER_NAME, "true");
                            VertxHttpRecorder.getRootHandler().handle(routingContext.request());
                        } else {
                            routingContext.next();
                        }
                    }
                }
            });
            return;
        }
        if (this.hotReplacementContext.getDeploymentProblem() != null) {
            VertxHttpHotReplacementSetup.handleDeploymentProblem(routingContext, this.hotReplacementContext.getDeploymentProblem());
            return;
        }
        routingContext.next();
    }

    public static void handleDeploymentProblem(RoutingContext routingContext, Throwable exception) {
        String bodyText = ReplacementDebugPage.generateHtml(exception);
        HttpServerResponse response = routingContext.response();
        response.setStatusCode(500);
        response.headers().add("Content-Type", "text/html; charset=UTF-8");
        response.end(bodyText);
    }

    @Override
    public void close() {
        ErrorPageGenerators.clear();
        VertxHttpRecorder.shutDownDevMode();
    }
}

