/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.logstream;

import io.quarkus.vertx.http.runtime.devmode.Json;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeMap;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;

public class LogController {
    private static final org.jboss.logging.Logger LOG = org.jboss.logging.Logger.getLogger(LogController.class);
    public static final List<String> LEVELS = new ArrayList<String>();

    private LogController() {
    }

    public static Json.JsonArrayBuilder getLevels() {
        Json.JsonArrayBuilder array = Json.array();
        for (String level : LEVELS) {
            array.add(level);
        }
        return array;
    }

    public static Json.JsonArrayBuilder getLoggers() {
        LogContext logContext = LogContext.getLogContext();
        TreeMap<String, Json.JsonObjectBuilder> loggerMap = new TreeMap<String, Json.JsonObjectBuilder>();
        Enumeration<String> loggerNames = logContext.getLoggerNames();
        while (loggerNames.hasMoreElements()) {
            String loggerName = loggerNames.nextElement();
            Json.JsonObjectBuilder jsonObject = LogController.getLogger(loggerName);
            if (jsonObject == null) continue;
            loggerMap.put(loggerName, jsonObject);
        }
        ArrayList<Json.JsonObjectBuilder> orderedLoggers = new ArrayList<Json.JsonObjectBuilder>(loggerMap.values());
        Json.JsonArrayBuilder jsonArray = Json.array();
        jsonArray.addAll(orderedLoggers);
        return jsonArray;
    }

    public static Json.JsonObjectBuilder getLogger(String loggerName) {
        LogContext logContext = LogContext.getLogContext();
        if (loggerName != null && !loggerName.isEmpty()) {
            Logger logger2 = logContext.getLogger(loggerName);
            Json.JsonObjectBuilder jsonObject = Json.object();
            jsonObject.put("name", loggerName);
            jsonObject.put("effectiveLevel", LogController.getEffectiveLogLevel(logger2));
            jsonObject.put("configuredLevel", LogController.getConfiguredLogLevel(logger2));
            return jsonObject;
        }
        return null;
    }

    public static void updateLogLevel(String loggerName, String levelValue) {
        LogContext logContext = LogContext.getLogContext();
        Logger logger2 = logContext.getLogger(loggerName);
        if (logger2 != null) {
            java.util.logging.Level level = Level.parse(levelValue);
            logger2.setLevel(level);
            LOG.info("Log level updated [" + loggerName + "] changed to [" + levelValue + "]");
        }
    }

    private static String getConfiguredLogLevel(Logger logger2) {
        java.util.logging.Level level = logger2.getLevel();
        return level != null ? level.getName() : null;
    }

    private static String getEffectiveLogLevel(Logger logger2) {
        if (logger2 == null) {
            return null;
        }
        if (logger2.getLevel() != null) {
            return logger2.getLevel().getName();
        }
        return LogController.getEffectiveLogLevel(logger2.getParent());
    }

    static {
        LEVELS.add(Level.OFF.getName());
        LEVELS.add(Level.SEVERE.getName());
        LEVELS.add(Level.ERROR.getName());
        LEVELS.add(Level.FATAL.getName());
        LEVELS.add(Level.WARNING.getName());
        LEVELS.add(Level.WARN.getName());
        LEVELS.add(Level.INFO.getName());
        LEVELS.add(Level.DEBUG.getName());
        LEVELS.add(Level.TRACE.getName());
        LEVELS.add(Level.CONFIG.getName());
        LEVELS.add(Level.FINE.getName());
        LEVELS.add(Level.FINER.getName());
        LEVELS.add(Level.FINEST.getName());
        LEVELS.add(Level.ALL.getName());
    }
}

