/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Handler;
import org.graalvm.collections.UnmodifiableEconomicSet;
import org.graalvm.home.HomeFinder;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Instrument;
import org.graalvm.polyglot.Language;
import org.graalvm.polyglot.PolyglotAccess;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.ResourceLimitEvent;
import org.graalvm.polyglot.ResourceLimits;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.SourceSection;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.io.ByteSequence;
import org.graalvm.polyglot.io.FileSystem;
import org.graalvm.polyglot.io.MessageTransport;
import org.graalvm.polyglot.management.ExecutionEvent;

public final class Engine
implements AutoCloseable {
    final AbstractPolyglotImpl.AbstractEngineImpl impl;
    private static final Engine EMPTY = new Engine(null);
    private static final boolean JDK8_OR_EARLIER = System.getProperty("java.specification.version").compareTo("1.9") < 0;

    Engine(AbstractPolyglotImpl.AbstractEngineImpl impl) {
        this.impl = impl;
    }

    public Map<String, Language> getLanguages() {
        return this.impl.getLanguages();
    }

    public Map<String, Instrument> getInstruments() {
        return this.impl.getInstruments();
    }

    public OptionDescriptors getOptions() {
        return this.impl.getOptions();
    }

    public String getVersion() {
        String version = HomeFinder.getInstance().getVersion();
        if (version.equals("snapshot")) {
            return "Development Build";
        }
        return version;
    }

    public void close(boolean cancelIfExecuting) {
        this.impl.close(this, cancelIfExecuting);
    }

    @Override
    public void close() {
        this.close(false);
    }

    public String getImplementationName() {
        return this.impl.getImplementationName();
    }

    public static Engine create() {
        return Engine.newBuilder().build();
    }

    public static Builder newBuilder() {
        return EMPTY.new Builder();
    }

    public static Path findHome() {
        return HomeFinder.getInstance().getHomeFolder();
    }

    public Set<Source> getCachedSources() {
        return this.impl.getCachedSources();
    }

    static AbstractPolyglotImpl getImpl() {
        return ImplHolder.IMPL;
    }

    static Class<?> loadLanguageClass(String className) {
        return Engine.getImpl().loadLanguageClass(className);
    }

    static Collection<Engine> findActiveEngines() {
        return Engine.getImpl().findActiveEngines();
    }

    private static AbstractPolyglotImpl initEngineImpl() {
        return AccessController.doPrivileged(new PrivilegedAction<AbstractPolyglotImpl>(){

            @Override
            public AbstractPolyglotImpl run() {
                AbstractPolyglotImpl engine = null;
                Class<?> servicesClass = null;
                if (Boolean.getBoolean("graalvm.ForcePolyglotInvalid")) {
                    engine = Engine.createInvalidPolyglotImpl();
                } else if (JDK8_OR_EARLIER) {
                    try {
                        servicesClass = Class.forName("jdk.vm.ci.services.Services");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    if (servicesClass != null) {
                        try {
                            Method m = servicesClass.getDeclaredMethod("loadSingle", Class.class, Boolean.TYPE);
                            engine = (AbstractPolyglotImpl)m.invoke(null, AbstractPolyglotImpl.class, false);
                        }
                        catch (Throwable e) {
                            throw new InternalError(e);
                        }
                    }
                }
                if (engine == null) {
                    engine = this.searchServiceLoader();
                }
                if (engine == null) {
                    engine = Engine.createInvalidPolyglotImpl();
                }
                if (engine != null) {
                    engine.setConstructors(new APIAccessImpl());
                }
                return engine;
            }

            private AbstractPolyglotImpl searchServiceLoader() throws InternalError {
                Iterator<AbstractPolyglotImpl> providers = ServiceLoader.load(AbstractPolyglotImpl.class).iterator();
                if (providers.hasNext()) {
                    AbstractPolyglotImpl found = providers.next();
                    if (providers.hasNext()) {
                        throw new InternalError(String.format("Multiple %s providers found", AbstractPolyglotImpl.class.getName()));
                    }
                    return found;
                }
                return null;
            }
        });
    }

    static AbstractPolyglotImpl createInvalidPolyglotImpl() {
        return new PolyglotInvalid();
    }

    static /* synthetic */ AbstractPolyglotImpl access$000() {
        return Engine.initEngineImpl();
    }

    private static class PolyglotInvalid
    extends AbstractPolyglotImpl {
        private final EmptySource source = new EmptySource(this);
        static boolean AOT;

        private PolyglotInvalid() {
        }

        @Override
        public Context getCurrentContext() {
            throw PolyglotInvalid.noPolyglotImplementationFound();
        }

        @Override
        public Engine buildEngine(OutputStream out, OutputStream err, InputStream in, Map<String, String> arguments, boolean useSystemProperties, boolean allowExperimentalOptions, boolean boundEngine, MessageTransport messageInterceptor, Object logHandlerOrStream, HostAccess conf) {
            throw PolyglotInvalid.noPolyglotImplementationFound();
        }

        @Override
        public Object buildLimits(long statementLimit, Predicate<Source> statementLimitSourceFilter, Consumer<ResourceLimitEvent> onLimit) {
            throw PolyglotInvalid.noPolyglotImplementationFound();
        }

        @Override
        public Context getLimitEventContext(Object impl) {
            throw PolyglotInvalid.noPolyglotImplementationFound();
        }

        @Override
        public AbstractPolyglotImpl.AbstractManagementImpl getManagementImpl() {
            return new AbstractPolyglotImpl.AbstractManagementImpl(this){

                @Override
                public boolean isExecutionEventStatement(Object impl) {
                    return false;
                }

                @Override
                public boolean isExecutionEventRoot(Object impl) {
                    return false;
                }

                @Override
                public boolean isExecutionEventExpression(Object impl) {
                    return false;
                }

                @Override
                public String getExecutionEventRootName(Object impl) {
                    throw PolyglotInvalid.noPolyglotImplementationFound();
                }

                @Override
                public PolyglotException getExecutionEventException(Object impl) {
                    throw PolyglotInvalid.noPolyglotImplementationFound();
                }

                @Override
                public Value getExecutionEventReturnValue(Object impl) {
                    throw PolyglotInvalid.noPolyglotImplementationFound();
                }

                @Override
                public SourceSection getExecutionEventLocation(Object impl) {
                    throw PolyglotInvalid.noPolyglotImplementationFound();
                }

                @Override
                public List<Value> getExecutionEventInputValues(Object impl) {
                    throw PolyglotInvalid.noPolyglotImplementationFound();
                }

                @Override
                public void closeExecutionListener(Object impl) {
                    throw PolyglotInvalid.noPolyglotImplementationFound();
                }

                @Override
                public Object attachExecutionListener(Engine engine, Consumer<ExecutionEvent> onEnter, Consumer<ExecutionEvent> onReturn, boolean expressions, boolean statements, boolean roots, Predicate<Source> sourceFilter, Predicate<String> rootFilter, boolean collectInputValues, boolean collectReturnValues, boolean collectErrors) {
                    throw PolyglotInvalid.noPolyglotImplementationFound();
                }
            };
        }

        private static RuntimeException noPolyglotImplementationFound() {
            String suggestion = AOT ? "Make sure a language is added to the classpath (e.g., native-image --language:js)." : "Make sure the truffle-api.jar is on the classpath.";
            return new IllegalStateException("No language and polyglot implementation was found on the classpath. " + suggestion);
        }

        @Override
        public AbstractPolyglotImpl.AbstractSourceImpl getSourceImpl() {
            return this.source;
        }

        @Override
        public AbstractPolyglotImpl.AbstractSourceSectionImpl getSourceSectionImpl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class<?> loadLanguageClass(String className) {
            return null;
        }

        @Override
        public Collection<Engine> findActiveEngines() {
            return Collections.emptyList();
        }

        @Override
        public void preInitializeEngine() {
        }

        @Override
        public void resetPreInitializedEngine() {
        }

        @Override
        public Value asValue(Object o) {
            throw PolyglotInvalid.noPolyglotImplementationFound();
        }

        @Override
        public FileSystem newDefaultFileSystem() {
            throw PolyglotInvalid.noPolyglotImplementationFound();
        }

        @Override
        public <S, T> Object newTargetTypeMapping(Class<S> sourceType, Class<T> targetType, Predicate<S> acceptsValue, Function<S, T> convertValue, HostAccess.TargetMappingPrecedence precedence) {
            return new Object();
        }

        static {
            Boolean aot = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return Boolean.getBoolean("com.oracle.graalvm.isaot");
                }
            });
            AOT = aot;
        }

        static class EmptySource
        extends AbstractPolyglotImpl.AbstractSourceImpl {
            protected EmptySource(AbstractPolyglotImpl engineImpl) {
                super(engineImpl);
            }

            @Override
            public Source build(String language, Object origin, URI uri, String name, String mimeType, Object content, boolean interactive, boolean internal, boolean cached, Charset encoding) throws IOException {
                throw PolyglotInvalid.noPolyglotImplementationFound();
            }

            @Override
            public String getLanguage(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String findLanguage(File file) throws IOException {
                return null;
            }

            @Override
            public String findLanguage(URL url) throws IOException {
                return null;
            }

            @Override
            public String findMimeType(File file) throws IOException {
                return null;
            }

            @Override
            public String findMimeType(URL url) throws IOException {
                return null;
            }

            @Override
            public String getMimeType(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String findLanguage(String mimeType) {
                return null;
            }

            @Override
            public String getName(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getPath(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isInteractive(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public URL getURL(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public URI getURI(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Reader getReader(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public InputStream getInputStream(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getLength(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public CharSequence getCharacters(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public CharSequence getCharacters(Object impl, int lineNumber) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getLineCount(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getLineNumber(Object impl, int offset) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getColumnNumber(Object impl, int offset) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getLineStartOffset(Object impl, int lineNumber) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getLineLength(Object impl, int lineNumber) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String toString(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int hashCode(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean equals(Object impl, Object otherImpl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isInternal(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public ByteSequence getBytes(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasCharacters(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasBytes(Object impl) {
                throw new UnsupportedOperationException();
            }
        }
    }

    static class APIAccessImpl
    extends AbstractPolyglotImpl.APIAccess {
        APIAccessImpl() {
        }

        @Override
        public AbstractPolyglotImpl.AbstractContextImpl getImpl(Context context) {
            return context.impl;
        }

        @Override
        public Engine newEngine(AbstractPolyglotImpl.AbstractEngineImpl impl) {
            return new Engine(impl);
        }

        @Override
        public AbstractPolyglotImpl.AbstractExceptionImpl getImpl(PolyglotException value) {
            return value.impl;
        }

        @Override
        public Context newContext(AbstractPolyglotImpl.AbstractContextImpl impl) {
            return new Context(impl);
        }

        @Override
        public PolyglotException newLanguageException(String message, AbstractPolyglotImpl.AbstractExceptionImpl impl) {
            return new PolyglotException(message, impl);
        }

        @Override
        public Language newLanguage(AbstractPolyglotImpl.AbstractLanguageImpl impl) {
            return new Language(impl);
        }

        @Override
        public Instrument newInstrument(AbstractPolyglotImpl.AbstractInstrumentImpl impl) {
            return new Instrument(impl);
        }

        @Override
        public Value newValue(Object value, AbstractPolyglotImpl.AbstractValueImpl impl) {
            return new Value(impl, value);
        }

        @Override
        public Source newSource(Object impl) {
            return new Source(impl);
        }

        @Override
        public SourceSection newSourceSection(Source source, Object impl) {
            return new SourceSection(source, impl);
        }

        @Override
        public AbstractPolyglotImpl.AbstractEngineImpl getImpl(Engine value) {
            return value.impl;
        }

        @Override
        public AbstractPolyglotImpl.AbstractValueImpl getImpl(Value value) {
            return value.impl;
        }

        @Override
        public AbstractPolyglotImpl.AbstractInstrumentImpl getImpl(Instrument value) {
            return value.impl;
        }

        @Override
        public ResourceLimitEvent newResourceLimitsEvent(Object impl) {
            return new ResourceLimitEvent(impl);
        }

        @Override
        public AbstractPolyglotImpl.AbstractLanguageImpl getImpl(Language value) {
            return value.impl;
        }

        @Override
        public Object getImpl(ResourceLimits value) {
            return value.impl;
        }

        @Override
        public AbstractPolyglotImpl.AbstractStackFrameImpl getImpl(PolyglotException.StackFrame value) {
            return value.impl;
        }

        @Override
        public Object getReceiver(Value value) {
            return value.receiver;
        }

        @Override
        public PolyglotException.StackFrame newPolyglotStackTraceElement(PolyglotException e, AbstractPolyglotImpl.AbstractStackFrameImpl impl) {
            PolyglotException polyglotException = e;
            polyglotException.getClass();
            return new PolyglotException.StackFrame(polyglotException, impl);
        }

        @Override
        public boolean allowsAccess(HostAccess access, AnnotatedElement element) {
            return access.allowsAccess(element);
        }

        @Override
        public boolean allowsImplementation(HostAccess access, Class<?> type) {
            return access.allowsImplementation(type);
        }

        @Override
        public List<Object> getTargetMappings(HostAccess access) {
            return access.getTargetMappings();
        }

        @Override
        public boolean isArrayAccessible(HostAccess access) {
            return access.allowArrayAccess;
        }

        @Override
        public boolean isListAccessible(HostAccess access) {
            return access.allowListAccess;
        }

        @Override
        public boolean isBufferAccessible(HostAccess access) {
            return access.allowBufferAccess;
        }

        @Override
        public boolean isIterableAccessible(HostAccess access) {
            return access.allowIterableAccess;
        }

        @Override
        public boolean isIteratorAccessible(HostAccess access) {
            return access.allowIteratorAccess;
        }

        @Override
        public boolean isMapAccessible(HostAccess access) {
            return access.allowMapAccess;
        }

        @Override
        public Object getHostAccessImpl(HostAccess conf) {
            return conf.impl;
        }

        @Override
        public void setHostAccessImpl(HostAccess conf, Object impl) {
            conf.impl = impl;
        }

        @Override
        public UnmodifiableEconomicSet<String> getEvalAccess(PolyglotAccess access, String language) {
            return access.getEvalAccess(language);
        }

        @Override
        public UnmodifiableEconomicSet<String> getBindingsAccess(PolyglotAccess access) {
            return access.getBindingsAccess();
        }

        @Override
        public String validatePolyglotAccess(PolyglotAccess access, UnmodifiableEconomicSet<String> languages) {
            return access.validate(languages);
        }
    }

    public final class Builder {
        private OutputStream out = System.out;
        private OutputStream err = System.err;
        private InputStream in = System.in;
        private Map<String, String> options = new HashMap<String, String>();
        private boolean allowExperimentalOptions = false;
        private boolean useSystemProperties = true;
        private boolean boundEngine;
        private MessageTransport messageTransport;
        private Object customLogHandler;

        Builder() {
        }

        Builder setBoundEngine(boolean boundEngine) {
            this.boundEngine = boundEngine;
            return this;
        }

        public Builder out(OutputStream out) {
            Objects.requireNonNull(out);
            this.out = out;
            return this;
        }

        public Builder err(OutputStream err) {
            Objects.requireNonNull(err);
            this.err = err;
            return this;
        }

        public Builder in(InputStream in) {
            Objects.requireNonNull(in);
            this.in = in;
            return this;
        }

        public Builder allowExperimentalOptions(boolean enabled) {
            this.allowExperimentalOptions = enabled;
            return this;
        }

        public Builder useSystemProperties(boolean enabled) {
            this.useSystemProperties = enabled;
            return this;
        }

        public Builder option(String key, String value) {
            Objects.requireNonNull(key, "Key must not be null.");
            Objects.requireNonNull(value, "Value must not be null.");
            this.options.put(key, value);
            return this;
        }

        public Builder options(Map<String, String> options) {
            for (String key : options.keySet()) {
                Objects.requireNonNull(options.get(key), "All option values must be non-null.");
            }
            this.options.putAll(options);
            return this;
        }

        public Builder serverTransport(MessageTransport serverTransport) {
            Objects.requireNonNull(serverTransport, "MessageTransport must be non null.");
            this.messageTransport = serverTransport;
            return this;
        }

        public Builder logHandler(Handler logHandler) {
            Objects.requireNonNull(logHandler, "Handler must be non null.");
            this.customLogHandler = logHandler;
            return this;
        }

        public Builder logHandler(OutputStream logOut) {
            Objects.requireNonNull(logOut, "LogOut must be non null.");
            this.customLogHandler = logOut;
            return this;
        }

        public Engine build() {
            AbstractPolyglotImpl loadedImpl = Engine.getImpl();
            if (loadedImpl == null) {
                throw new IllegalStateException("The Polyglot API implementation failed to load.");
            }
            return loadedImpl.buildEngine(this.out, this.err, this.in, this.options, this.useSystemProperties, this.allowExperimentalOptions, this.boundEngine, this.messageTransport, this.customLogHandler, null);
        }
    }

    private static final class ImplHolder {
        private static final AbstractPolyglotImpl IMPL = Engine.access$000();

        private ImplHolder() {
        }

        private static void preInitializeEngine() {
            IMPL.preInitializeEngine();
        }

        private static void resetPreInitializedEngine() {
            IMPL.resetPreInitializedEngine();
        }

        private static void debugContextPreInitialization() {
            if (!ImageInfo.inImageCode() && System.getProperty("polyglot.image-build-time.PreinitializeContexts") != null) {
                IMPL.preInitializeEngine();
            }
        }

        static {
            ImplHolder.debugContextPreInitialization();
        }
    }
}

