/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.kie.kogito.ReflectiveModelAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Models {
    private static final Logger LOGGER = LoggerFactory.getLogger(Models.class);
    private static final String CLASS_PROP = "class";
    private static final String ID_PROP = "id";
    private static final String VAR_PREFIX = "v$";

    private Models() {
    }

    public static Map<String, Object> toMap(Object m) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            BeanInfo beanInfo = Introspector.getBeanInfo(m.getClass());
            Map<String, PropertyDescriptor> descriptors = Models.descriptorMap(beanInfo);
            for (Map.Entry<String, PropertyDescriptor> e : descriptors.entrySet()) {
                String k = e.getKey();
                if (Models.isIdentifier(k)) {
                    LOGGER.trace("Models#toMap: Skipping `id` property for class `{}`", (Object)m.getClass().getCanonicalName());
                    continue;
                }
                k = Models.unprefixVar(k);
                map.put(k, e.getValue().getReadMethod().invoke(m, new Object[0]));
            }
            return map;
        }
        catch (IntrospectionException | ReflectiveOperationException e) {
            throw new ReflectiveModelAccessException(e);
        }
    }

    public static <T> T fromMap(T m, String id, Map<String, Object> map) {
        Models.setId(m, id);
        return Models.fromMap(m, map);
    }

    public static <T> T fromMap(T m, Map<String, Object> map) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(m.getClass());
            Map<String, PropertyDescriptor> descriptors = Models.descriptorMap(beanInfo);
            for (Map.Entry<String, PropertyDescriptor> e : descriptors.entrySet()) {
                String k = e.getKey();
                if (!map.containsKey(k = Models.unprefixVar(k))) continue;
                e.getValue().getWriteMethod().invoke(m, map.get(k));
            }
            return m;
        }
        catch (IntrospectionException | ReflectiveOperationException e) {
            throw new ReflectiveModelAccessException(e);
        }
    }

    public static <T> T fromMap(Class<T> cls, Map<String, Object> map) {
        try {
            Constructor<T> constructor = cls.getConstructor(new Class[0]);
            T t = constructor.newInstance(new Object[0]);
            Models.fromMap(t, map);
            return t;
        }
        catch (NoSuchMethodException e) {
            throw new ReflectiveModelAccessException(String.format("Class `%s` must declare an empty constructor.", cls.getCanonicalName()), e);
        }
        catch (ReflectiveOperationException e) {
            throw new ReflectiveModelAccessException(e);
        }
    }

    public static void setId(Object m, String id) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(m.getClass());
            for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
                if (!Models.isIdentifier(pd.getName())) continue;
                pd.getWriteMethod().invoke(m, id);
                return;
            }
            throw new ReflectiveModelAccessException(String.format("No `id` property found for class `%s`. Have you defined getters and setters?", m.getClass().getCanonicalName()));
        }
        catch (IntrospectionException | ReflectiveOperationException e) {
            throw new ReflectiveModelAccessException(e);
        }
    }

    public static <I, O> O convert(I in, O out) {
        Models.fromMap(out, Models.toMap(in));
        return out;
    }

    private static String unprefixVar(String k) {
        if (k.startsWith(VAR_PREFIX)) {
            k = k.substring(VAR_PREFIX.length());
        }
        return k;
    }

    private static boolean isIdentifier(String k) {
        return k.equals(ID_PROP);
    }

    private static Map<String, PropertyDescriptor> descriptorMap(BeanInfo beanInfo) {
        return Arrays.stream(beanInfo.getPropertyDescriptors()).filter(pd -> !pd.getName().equals(CLASS_PROP)).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
    }
}

