/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.common.messaging.incoming;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEvent;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.kie.kogito.explainability.api.BaseExplainabilityResultDto;
import org.kie.kogito.trusty.service.common.TrustyService;
import org.kie.kogito.trusty.service.common.handlers.ExplainerServiceHandlerRegistry;
import org.kie.kogito.trusty.service.common.messaging.BaseEventConsumer;
import org.kie.kogito.trusty.storage.api.StorageExceptionsProvider;
import org.kie.kogito.trusty.storage.api.model.BaseExplainabilityResult;
import org.kie.kogito.trusty.storage.api.model.Decision;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ExplainabilityResultConsumer
extends BaseEventConsumer<BaseExplainabilityResultDto> {
    private static final Logger LOG = LoggerFactory.getLogger(ExplainabilityResultConsumer.class);
    private static final TypeReference<BaseExplainabilityResultDto> CLOUD_EVENT_TYPE = new TypeReference<BaseExplainabilityResultDto>(){};
    private ExplainerServiceHandlerRegistry explainerServiceHandlerRegistry;

    ExplainabilityResultConsumer() {
    }

    @Inject
    public ExplainabilityResultConsumer(TrustyService service, ExplainerServiceHandlerRegistry explainerServiceHandlerRegistry, ObjectMapper mapper, StorageExceptionsProvider storageExceptionsProvider) {
        super(service, mapper, storageExceptionsProvider);
        this.explainerServiceHandlerRegistry = explainerServiceHandlerRegistry;
    }

    protected <T extends BaseExplainabilityResultDto> BaseExplainabilityResult explainabilityResultFrom(T dto, Decision decision) {
        return this.explainerServiceHandlerRegistry.explainabilityResultFrom(dto, decision);
    }

    @Override
    @Incoming(value="trusty-explainability-result")
    public CompletionStage<Void> handleMessage(Message<String> message) {
        return super.handleMessage(message);
    }

    @Override
    protected void internalHandleCloudEvent(CloudEvent cloudEvent, BaseExplainabilityResultDto payload) {
        LOG.debug("CloudEvent received {}", (Object)payload);
        String executionId = payload.getExecutionId();
        Decision decision = this.getDecisionById(executionId);
        if (decision == null) {
            LOG.warn("Can't find decision related to explainability result (executionId={})", (Object)executionId);
        }
        this.service.storeExplainabilityResult(executionId, this.explainabilityResultFrom(payload, decision));
    }

    @Override
    protected TypeReference<BaseExplainabilityResultDto> getEventType() {
        return CLOUD_EVENT_TYPE;
    }

    protected Decision getDecisionById(String executionId) {
        try {
            return this.service.getDecisionById(executionId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

