/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.predicates;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BinaryOperator;
import org.kie.pmml.api.enums.BOOLEAN_OPERATOR;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;
import org.kie.pmml.commons.model.predicates.KiePMMLPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLCompoundPredicate
extends KiePMMLPredicate {
    private static final Logger logger = LoggerFactory.getLogger(KiePMMLCompoundPredicate.class);
    private static final long serialVersionUID = -8106791592643949001L;
    private final BOOLEAN_OPERATOR booleanOperator;
    protected BinaryOperator<Boolean> operatorFunction;
    protected List<KiePMMLPredicate> kiePMMLPredicates;

    protected KiePMMLCompoundPredicate(String name, List<KiePMMLExtension> extensions, BOOLEAN_OPERATOR booleanOperator) {
        super(name, extensions);
        this.booleanOperator = booleanOperator;
    }

    public static Builder builder(List<KiePMMLExtension> extensions, BOOLEAN_OPERATOR booleanOperator) {
        return new Builder(extensions, booleanOperator);
    }

    @Override
    public boolean evaluate(Map<String, Object> values) {
        Boolean toReturn = null;
        block6: for (KiePMMLPredicate kiePMMLPredicate : this.kiePMMLPredicates) {
            Boolean evaluation = kiePMMLPredicate.evaluate(values);
            switch (this.booleanOperator) {
                case OR: {
                    toReturn = KiePMMLCompoundPredicate.orOperator(toReturn, evaluation);
                    continue block6;
                }
                case AND: {
                    toReturn = KiePMMLCompoundPredicate.andOperator(toReturn, evaluation);
                    continue block6;
                }
                case XOR: {
                    toReturn = KiePMMLCompoundPredicate.xorOperator(toReturn, evaluation);
                    continue block6;
                }
                case SURROGATE: {
                    toReturn = KiePMMLCompoundPredicate.surrogateOperator(toReturn, evaluation);
                    continue block6;
                }
            }
            throw new KiePMMLException("Unknown BOOLEAN_OPERATOR " + (Object)((Object)this.booleanOperator));
        }
        return toReturn != null && toReturn != false;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public BOOLEAN_OPERATOR getBooleanOperator() {
        return this.booleanOperator;
    }

    public List<KiePMMLPredicate> getKiePMMLPredicates() {
        return this.kiePMMLPredicates;
    }

    public String toString() {
        return "KiePMMLCompoundPredicate{booleanOperator=" + (Object)((Object)this.booleanOperator) + ", operatorFunction=" + this.operatorFunction + ", kiePMMLPredicates=" + this.kiePMMLPredicates + ", extensions=" + this.extensions + ", id='" + this.id + '\'' + ", parentId='" + this.parentId + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KiePMMLCompoundPredicate that = (KiePMMLCompoundPredicate)o;
        return this.booleanOperator == that.booleanOperator && Objects.equals(this.operatorFunction, that.operatorFunction) && Objects.equals(this.kiePMMLPredicates, that.kiePMMLPredicates);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.booleanOperator, this.operatorFunction, this.kiePMMLPredicates});
    }

    static Boolean orOperator(Boolean aBoolean, Boolean aBoolean2) {
        logger.trace("orOperator {} {}", (Object)aBoolean, (Object)aBoolean2);
        return aBoolean != null ? aBoolean.booleanValue() || aBoolean2.booleanValue() : aBoolean2;
    }

    static Boolean andOperator(Boolean aBoolean, Boolean aBoolean2) {
        logger.trace("andOperator {} {}", (Object)aBoolean, (Object)aBoolean2);
        return aBoolean != null ? aBoolean.booleanValue() && aBoolean2.booleanValue() : aBoolean2;
    }

    static Boolean xorOperator(Boolean aBoolean, Boolean aBoolean2) {
        logger.trace("xorOperator {} {}", (Object)aBoolean, (Object)aBoolean2);
        return aBoolean != null ? aBoolean ^ aBoolean2 : aBoolean2;
    }

    static Boolean surrogateOperator(Boolean aBoolean, Boolean aBoolean2) {
        logger.trace("surrogateOperator {} {}", (Object)aBoolean, (Object)aBoolean2);
        return aBoolean != null ? aBoolean : aBoolean2;
    }

    public static class Builder
    extends AbstractKiePMMLComponent.Builder<KiePMMLCompoundPredicate> {
        private Builder(List<KiePMMLExtension> extensions, BOOLEAN_OPERATOR booleanOperator) {
            super("CompoundPredicate-", () -> new KiePMMLCompoundPredicate("CompoundPredicate", extensions, booleanOperator));
            ((KiePMMLCompoundPredicate)this.toBuild).operatorFunction = this.getInnerBinaryOperator(booleanOperator);
        }

        public Builder withKiePMMLPredicates(List<KiePMMLPredicate> kiePMMLPredicates) {
            kiePMMLPredicates.forEach(predicate -> predicate.setParentId(((KiePMMLCompoundPredicate)this.toBuild).id));
            ((KiePMMLCompoundPredicate)this.toBuild).kiePMMLPredicates = kiePMMLPredicates;
            return this;
        }

        private BinaryOperator<Boolean> getInnerBinaryOperator(BOOLEAN_OPERATOR booleanOperator) {
            switch (booleanOperator) {
                case OR: {
                    return KiePMMLCompoundPredicate::orOperator;
                }
                case AND: {
                    return KiePMMLCompoundPredicate::andOperator;
                }
                case XOR: {
                    return KiePMMLCompoundPredicate::xorOperator;
                }
                case SURROGATE: {
                    return KiePMMLCompoundPredicate::surrogateOperator;
                }
            }
            throw new KiePMMLException("Unknown BOOLEAN_OPERATOR " + (Object)((Object)booleanOperator));
        }
    }
}

