/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.runtime;

import io.quarkus.kubernetes.service.binding.runtime.ServiceBinding;
import io.quarkus.kubernetes.service.binding.runtime.ServiceBindingConfigSource;
import io.quarkus.kubernetes.service.binding.runtime.ServiceBindingConverter;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class KafkaBindingConverter
implements ServiceBindingConverter {
    public Optional<ServiceBindingConfigSource> convert(List<ServiceBinding> serviceBindings) {
        String saslMechanism;
        String securityProtocol;
        Optional matchingByType = ServiceBinding.singleMatchingByType((String)"kafka", serviceBindings);
        if (!matchingByType.isPresent()) {
            return Optional.empty();
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        ServiceBinding binding = (ServiceBinding)matchingByType.get();
        String bootstrapServers = (String)binding.getProperties().get("bootstrapServers");
        if (bootstrapServers == null) {
            bootstrapServers = (String)binding.getProperties().get("bootstrap-servers");
        }
        if (bootstrapServers != null) {
            properties.put("kafka.bootstrap.servers", bootstrapServers);
        }
        if ((securityProtocol = (String)binding.getProperties().get("securityProtocol")) != null) {
            properties.put("kafka.security.protocol", securityProtocol);
        }
        if ((saslMechanism = (String)binding.getProperties().get("saslMechanism")) != null) {
            properties.put("kafka.sasl.mechanism", saslMechanism);
        }
        String user = (String)binding.getProperties().get("user");
        String password = (String)binding.getProperties().get("password");
        if ("PLAIN".equals(saslMechanism) && user != null && password != null) {
            properties.put("kafka.sasl.jaas.config", String.format("org.apache.kafka.common.security.plain.PlainLoginModule required username='%s' password='%s';", user, password));
        }
        return Optional.of(new ServiceBindingConfigSource("kafka-k8s-service-binding-source", properties));
    }
}

