/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.devmode;

import io.quarkus.vertx.http.runtime.devmode.ConfigDescription;
import io.quarkus.vertx.http.runtime.devmode.ConfigSourceName;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.Expressions;
import io.smallrye.config.SmallRyeConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class ConfigDescriptionsSupplier
implements Supplier<Map<ConfigSourceName, List<ConfigDescription>>> {
    private List<ConfigDescription> configDescriptions;

    public ConfigDescriptionsSupplier() {
    }

    public ConfigDescriptionsSupplier(List<ConfigDescription> configDescriptions) {
        this.configDescriptions = configDescriptions;
    }

    @Override
    public Map<ConfigSourceName, List<ConfigDescription>> get() {
        TreeMap<ConfigSourceName, List<ConfigDescription>> ordered = new TreeMap<ConfigSourceName, List<ConfigDescription>>();
        ArrayList<String> properties = new ArrayList<String>();
        SmallRyeConfig current = (SmallRyeConfig)ConfigProvider.getConfig();
        for (ConfigDescription item : this.configDescriptions) {
            properties.add(item.getName());
            item.setConfigValue(current.getConfigValue(item.getName()));
            String configSourceName = item.getConfigValue().getConfigSourceName();
            int configSourceOrdinal = item.getConfigValue().getConfigSourceOrdinal();
            ordered.putIfAbsent(new ConfigSourceName(configSourceName, configSourceOrdinal), new ArrayList());
            ((List)ordered.get(new ConfigSourceName(configSourceName, configSourceOrdinal))).add(item);
        }
        for (ConfigSource configSource : current.getConfigSources()) {
            if (!configSource.getName().equals("PropertiesConfigSource[source=Build system]")) continue;
            properties.addAll(configSource.getPropertyNames());
        }
        Expressions.withoutExpansion(() -> {
            for (String propertyName : current.getPropertyNames()) {
                if (properties.contains(propertyName)) continue;
                ConfigDescription item = new ConfigDescription(propertyName, null, null, current.getConfigValue(propertyName));
                ConfigValue configValue = current.getConfigValue(propertyName);
                ConfigSourceName csn = new ConfigSourceName(configValue.getConfigSourceName(), configValue.getConfigSourceOrdinal());
                ordered.putIfAbsent(csn, new ArrayList());
                ((List)ordered.get(csn)).add(item);
                this.configDescriptions.add(item);
            }
        });
        return ordered;
    }

    public List<ConfigDescription> getConfigDescriptions() {
        return this.configDescriptions;
    }

    public void setConfigDescriptions(List<ConfigDescription> configDescriptions) {
        this.configDescriptions = configDescriptions;
    }
}

