/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.services;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.kie.api.internal.runtime.beliefs.KieBeliefService;
import org.kie.api.internal.runtime.beliefs.KieBeliefs;

public class KieBeliefsImpl
implements KieBeliefs,
Consumer<KieBeliefService> {
    private KieBeliefService[] services;
    private Map<String, KieBeliefService> beliefs = new HashMap<String, KieBeliefService>();

    @Override
    public Map<String, KieBeliefService> getBeliefs() {
        return this.beliefs;
    }

    public Class getServiceInterface() {
        return KieBeliefService.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KieBeliefService[] getServices() {
        if (this.services == null) {
            Map<String, KieBeliefService> map = this.beliefs;
            synchronized (map) {
                if (this.services != null) {
                    return this.services;
                }
                int size = this.beliefs.size();
                this.services = new KieBeliefService[size];
                int i = 0;
                for (KieBeliefService service : this.beliefs.values()) {
                    this.services[i++] = service;
                }
            }
        }
        return this.services;
    }

    @Override
    public void accept(KieBeliefService kieBeliefService) {
        this.beliefs.put(kieBeliefService.getBeliefType(), kieBeliefService);
    }
}

