/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.redis;

import io.redisearch.Client;
import io.redisearch.Query;
import io.redisearch.SearchResult;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.kogito.persistence.api.query.AttributeFilter;
import org.kie.kogito.persistence.api.query.AttributeSort;
import org.kie.kogito.persistence.api.query.SortDirection;
import org.kie.kogito.persistence.redis.JsonUtils;
import org.kie.kogito.persistence.redis.RedisQueryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisQuery<V>
implements org.kie.kogito.persistence.api.query.Query<V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisQuery.class);
    Integer limit;
    Integer offset;
    List<AttributeFilter<?>> filters;
    AttributeSort sortBy;
    String indexName;
    private Class<V> type;
    private Client redisClient;

    public RedisQuery(Client redisClient, String indexName, Class<V> type) {
        this.redisClient = redisClient;
        this.indexName = indexName;
        this.type = type;
    }

    @Override
    public org.kie.kogito.persistence.api.query.Query<V> limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public org.kie.kogito.persistence.api.query.Query<V> offset(Integer offset) {
        this.offset = offset;
        return this;
    }

    @Override
    public org.kie.kogito.persistence.api.query.Query<V> filter(List<AttributeFilter<?>> filters) {
        this.filters = filters;
        return this;
    }

    @Override
    public org.kie.kogito.persistence.api.query.Query<V> sort(List<AttributeSort> sortBy) {
        if (!sortBy.isEmpty()) {
            if (sortBy.size() > 1) {
                throw new UnsupportedOperationException("Multiple sorting attributes not implemented yet.");
            }
            this.sortBy = sortBy.get(0);
        }
        return this;
    }

    @Override
    public List<V> execute() {
        Query query = new Query(RedisQueryFactory.buildQueryBody(this.indexName, this.filters));
        this.setQueryLimitAndOffset(query);
        if (this.sortBy != null) {
            query.setSortBy(this.sortBy.getAttribute(), SortDirection.ASC.equals((Object)this.sortBy.getSort()));
        }
        RedisQueryFactory.addFilters(query, this.filters);
        SearchResult search = this.redisClient.search(query);
        LOGGER.debug(String.format("%d documets have been found for the query.", search.totalResults));
        return search.docs.stream().map(x -> {
            try {
                return JsonUtils.getMapper().readValue((String)x.get("rawObject"), this.type);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not deserialize a retrieved object.", e);
            }
        }).collect(Collectors.toList());
    }

    private void setQueryLimitAndOffset(Query query) {
        if (this.limit != null && this.offset == null) {
            LOGGER.warn("Limit was specified in Redis query but not the offset. Limit is ignored.");
            return;
        }
        if (this.limit == null && this.offset != null) {
            LOGGER.warn("Offset was specified in Redis query but not the limit. Offset is ignored.");
            return;
        }
        if (this.limit != null && this.offset != null) {
            query.limit(this.offset, this.limit);
        }
    }
}

