/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model;

import java.util.List;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.FIELD_USAGE_TYPE;
import org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD;
import org.kie.pmml.api.enums.MISSING_VALUE_TREATMENT_METHOD;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;
import org.kie.pmml.commons.model.expressions.KiePMMLInterval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLMiningField
extends AbstractKiePMMLComponent {
    private static final Logger logger = LoggerFactory.getLogger(KiePMMLMiningField.class);
    private static final long serialVersionUID = 2408750585433339543L;
    private FIELD_USAGE_TYPE fieldUsageType = FIELD_USAGE_TYPE.ACTIVE;
    private OP_TYPE opType = null;
    private DATA_TYPE dataType;
    private MISSING_VALUE_TREATMENT_METHOD missingValueTreatmentMethod;
    private INVALID_VALUE_TREATMENT_METHOD invalidValueTreatmentMethod;
    private List<String> allowedValues;
    private List<KiePMMLInterval> intervals;
    private String missingValueReplacement;
    private String invalidValueReplacement;

    private KiePMMLMiningField(String name, List<KiePMMLExtension> extensions) {
        super(name, extensions);
    }

    public boolean isMatching(Object toEvaluate) {
        if ((this.allowedValues == null || this.allowedValues.isEmpty()) && (this.intervals == null || this.intervals.isEmpty())) {
            return true;
        }
        if (toEvaluate == null) {
            return false;
        }
        if (this.allowedValues != null && !this.allowedValues.isEmpty()) {
            return this.allowedValues.contains(toEvaluate.toString());
        }
        if (toEvaluate instanceof Number) {
            return this.intervals.stream().anyMatch(interval -> interval.isIn((Number)toEvaluate));
        }
        return false;
    }

    public static Builder builder(String name, List<KiePMMLExtension> extensions) {
        return new Builder(name, extensions);
    }

    public FIELD_USAGE_TYPE getFieldUsageType() {
        return this.fieldUsageType;
    }

    public OP_TYPE getOpType() {
        return this.opType;
    }

    public DATA_TYPE getDataType() {
        return this.dataType;
    }

    public MISSING_VALUE_TREATMENT_METHOD getMissingValueTreatmentMethod() {
        return this.missingValueTreatmentMethod;
    }

    public INVALID_VALUE_TREATMENT_METHOD getInvalidValueTreatmentMethod() {
        return this.invalidValueTreatmentMethod;
    }

    public String getMissingValueReplacement() {
        return this.missingValueReplacement;
    }

    public String getInvalidValueReplacement() {
        return this.invalidValueReplacement;
    }

    public List<String> getAllowedValues() {
        return this.allowedValues;
    }

    public List<KiePMMLInterval> getIntervals() {
        return this.intervals;
    }

    public boolean isTarget() {
        return this.fieldUsageType == FIELD_USAGE_TYPE.TARGET || this.fieldUsageType == FIELD_USAGE_TYPE.PREDICTED;
    }

    public static class Builder
    extends AbstractKiePMMLComponent.Builder<KiePMMLMiningField> {
        private Builder(String name, List<KiePMMLExtension> extensions) {
            super("MiningField-", () -> new KiePMMLMiningField(name, extensions));
        }

        public Builder withFieldUsageType(FIELD_USAGE_TYPE fieldUsageType) {
            if (fieldUsageType != null) {
                ((KiePMMLMiningField)this.toBuild).fieldUsageType = fieldUsageType;
            }
            return this;
        }

        public Builder withOpType(OP_TYPE opType) {
            if (opType != null) {
                ((KiePMMLMiningField)this.toBuild).opType = opType;
            }
            return this;
        }

        public Builder withDataType(DATA_TYPE dataType) {
            if (dataType != null) {
                ((KiePMMLMiningField)this.toBuild).dataType = dataType;
            }
            return this;
        }

        public Builder withMissingValueTreatmentMethod(MISSING_VALUE_TREATMENT_METHOD missingValueTreatmentMethod) {
            if (missingValueTreatmentMethod != null) {
                ((KiePMMLMiningField)this.toBuild).missingValueTreatmentMethod = missingValueTreatmentMethod;
            }
            return this;
        }

        public Builder withInvalidValueTreatmentMethod(INVALID_VALUE_TREATMENT_METHOD invalidValueTreatmentMethod) {
            if (invalidValueTreatmentMethod != null) {
                ((KiePMMLMiningField)this.toBuild).invalidValueTreatmentMethod = invalidValueTreatmentMethod;
            }
            return this;
        }

        public Builder withMissingValueReplacement(String missingValueReplacement) {
            if (missingValueReplacement != null) {
                ((KiePMMLMiningField)this.toBuild).missingValueReplacement = missingValueReplacement;
            }
            return this;
        }

        public Builder withInvalidValueReplacement(String invalidValueReplacement) {
            if (invalidValueReplacement != null) {
                ((KiePMMLMiningField)this.toBuild).invalidValueReplacement = invalidValueReplacement;
            }
            return this;
        }

        public Builder withAllowedValues(List<String> allowedValues) {
            if (allowedValues != null) {
                ((KiePMMLMiningField)this.toBuild).allowedValues = allowedValues;
            }
            return this;
        }

        public Builder withIntervals(List<KiePMMLInterval> intervals) {
            if (intervals != null) {
                ((KiePMMLMiningField)this.toBuild).intervals = intervals;
            }
            return this;
        }
    }
}

