/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.runtime;

import io.quarkus.smallrye.openapi.runtime.OpenApiConstants;
import io.quarkus.smallrye.openapi.runtime.OpenApiDocumentHolder;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiConfigImpl;
import io.smallrye.openapi.api.OpenApiDocument;
import io.smallrye.openapi.runtime.OpenApiProcessor;
import io.smallrye.openapi.runtime.OpenApiStaticFile;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.OpenAPI;

@ApplicationScoped
public class OpenApiDocumentService
implements OpenApiDocumentHolder {
    private final OpenApiDocumentHolder documentHolder;

    public OpenApiDocumentService() {
    }

    public OpenApiDocumentService(OASFilter autoSecurityFilter, Config config) {
        this.documentHolder = config.getOptionalValue("quarkus.smallrye-openapi.always-run-filter", Boolean.class).orElse(Boolean.FALSE) != false ? new DynamicDocument(config, autoSecurityFilter) : new StaticDocument(config, autoSecurityFilter);
    }

    @Override
    public byte[] getJsonDocument() {
        return this.documentHolder.getJsonDocument();
    }

    @Override
    public byte[] getYamlDocument() {
        return this.documentHolder.getYamlDocument();
    }

    static class DynamicDocument
    implements OpenApiDocumentHolder {
        private OpenAPI generatedOnBuild;
        private OpenApiConfig openApiConfig;
        private OASFilter userFilter;
        private OASFilter autoFilter;

        DynamicDocument(Config config, OASFilter autoFilter) {
            block13: {
                ClassLoader cl = OpenApiConstants.classLoader == null ? Thread.currentThread().getContextClassLoader() : OpenApiConstants.classLoader;
                try (InputStream is = cl.getResourceAsStream("META-INF/quarkus-generated-openapi-doc." + Format.JSON);){
                    if (is == null) break block13;
                    try (OpenApiStaticFile staticFile = new OpenApiStaticFile(is, Format.JSON);){
                        this.generatedOnBuild = OpenApiProcessor.modelFromStaticFile(staticFile);
                        this.openApiConfig = new OpenApiConfigImpl(config);
                        this.userFilter = OpenApiProcessor.getFilter(this.openApiConfig, cl);
                        this.autoFilter = autoFilter;
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException("Could not find [META-INF/quarkus-generated-openapi-doc." + Format.JSON + "]");
                }
            }
        }

        @Override
        public byte[] getJsonDocument() {
            try {
                OpenApiDocument document = this.getOpenApiDocument();
                byte[] jsonDocument = OpenApiSerializer.serialize(document.get(), Format.JSON).getBytes(StandardCharsets.UTF_8);
                document.reset();
                document = null;
                return jsonDocument;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public byte[] getYamlDocument() {
            try {
                OpenApiDocument document = this.getOpenApiDocument();
                byte[] yamlDocument = OpenApiSerializer.serialize(document.get(), Format.YAML).getBytes(StandardCharsets.UTF_8);
                document.reset();
                document = null;
                return yamlDocument;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        private OpenApiDocument getOpenApiDocument() {
            OpenApiDocument document = OpenApiDocument.INSTANCE;
            document.reset();
            document.config(this.openApiConfig);
            document.modelFromStaticFile(this.generatedOnBuild);
            if (this.autoFilter != null) {
                document.filter(this.autoFilter);
            }
            document.filter(this.userFilter);
            document.initialize();
            return document;
        }
    }

    static class StaticDocument
    implements OpenApiDocumentHolder {
        private byte[] jsonDocument;
        private byte[] yamlDocument;

        StaticDocument(Config config, OASFilter autoFilter) {
            block14: {
                ClassLoader cl = OpenApiConstants.classLoader == null ? Thread.currentThread().getContextClassLoader() : OpenApiConstants.classLoader;
                try (InputStream is = cl.getResourceAsStream("META-INF/quarkus-generated-openapi-doc." + Format.JSON);){
                    if (is == null) break block14;
                    try (OpenApiStaticFile staticFile = new OpenApiStaticFile(is, Format.JSON);){
                        OpenApiConfigImpl openApiConfig = new OpenApiConfigImpl(config);
                        OpenApiDocument document = OpenApiDocument.INSTANCE;
                        document.reset();
                        document.config(openApiConfig);
                        document.modelFromStaticFile(OpenApiProcessor.modelFromStaticFile(staticFile));
                        if (autoFilter != null) {
                            document.filter(autoFilter);
                        }
                        document.filter(OpenApiProcessor.getFilter(openApiConfig, cl));
                        document.initialize();
                        this.jsonDocument = OpenApiSerializer.serialize(document.get(), Format.JSON).getBytes(StandardCharsets.UTF_8);
                        this.yamlDocument = OpenApiSerializer.serialize(document.get(), Format.YAML).getBytes(StandardCharsets.UTF_8);
                        document.reset();
                        document = null;
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException("Could not find [META-INF/quarkus-generated-openapi-doc." + Format.JSON + "]");
                }
            }
        }

        @Override
        public byte[] getJsonDocument() {
            return this.jsonDocument;
        }

        @Override
        public byte[] getYamlDocument() {
            return this.yamlDocument;
        }
    }
}

