/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.RESULT_FEATURE;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.model.ProcessingDTO;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;
import org.kie.pmml.commons.model.expressions.KiePMMLExpression;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLOutputField
extends AbstractKiePMMLComponent {
    private static final Logger logger = LoggerFactory.getLogger(KiePMMLOutputField.class);
    private static final long serialVersionUID = 2408750585433339543L;
    private RESULT_FEATURE resultFeature = RESULT_FEATURE.PREDICTED_VALUE;
    private String targetField = null;
    private Integer rank;
    private DATA_TYPE dataType;
    private Object value;
    private KiePMMLExpression kiePMMLExpression;

    private KiePMMLOutputField(String name, List<KiePMMLExtension> extensions) {
        super(name, extensions);
    }

    public static Builder builder(String name, List<KiePMMLExtension> extensions) {
        return new Builder(name, extensions);
    }

    static Optional<Object> getValueFromKiePMMLNameValuesByVariableName(String variableName, List<KiePMMLNameValue> kiePMMLNameValues) {
        return kiePMMLNameValues.stream().filter(kiePMMLNameValue -> kiePMMLNameValue.getValue() != null && kiePMMLNameValue.getName().equals(variableName)).map(KiePMMLNameValue::getValue).findFirst();
    }

    static Optional<Object> getValueFromPMMLResultByVariableName(String variableName, Map<String, Object> resultsVariables) {
        return Optional.ofNullable(resultsVariables.get(variableName));
    }

    public RESULT_FEATURE getResultFeature() {
        return this.resultFeature;
    }

    public Optional<String> getTargetField() {
        return Optional.ofNullable(this.targetField);
    }

    public Object getValue() {
        return this.value;
    }

    public Integer getRank() {
        return this.rank;
    }

    public KiePMMLExpression getKiePMMLExpression() {
        return this.kiePMMLExpression;
    }

    public Object evaluate(ProcessingDTO processingDTO) {
        switch (this.resultFeature) {
            case PREDICTED_VALUE: {
                return this.evaluatePredictedValue(processingDTO);
            }
            case PROBABILITY: {
                return this.evaluateProbabilityValue(processingDTO);
            }
            case REASON_CODE: {
                return this.evaluateReasonCodeValue(processingDTO);
            }
            case TRANSFORMED_VALUE: {
                return this.evaluateTransformedValue(processingDTO);
            }
            case PREDICTED_DISPLAY_VALUE: {
                return processingDTO.getPredictedDisplayValue();
            }
            case ENTITY_ID: 
            case CLUSTER_ID: {
                return processingDTO.getEntityId();
            }
            case AFFINITY: 
            case ENTITY_AFFINITY: 
            case CLUSTER_AFFINITY: {
                return processingDTO.getAffinity();
            }
        }
        logger.warn("OutputField with feature \"{}\" is currently not implemented and will be ignored.", (Object)this.resultFeature.getName());
        return null;
    }

    public Object evaluatePredictedValue(ProcessingDTO processingDTO) {
        return KiePMMLModelUtils.commonEvaluate(KiePMMLOutputField.getValueFromKiePMMLNameValuesByVariableName(this.targetField, processingDTO.getKiePMMLNameValues()).orElse(null), this.dataType);
    }

    public Object evaluateProbabilityValue(ProcessingDTO processingDTO) {
        return processingDTO.getProbabilityMap() != null ? processingDTO.getProbabilityMap().get(this.value) : null;
    }

    public Object evaluateReasonCodeValue(ProcessingDTO processingDTO) {
        List<String> orderedReasonCodes = processingDTO.getOrderedReasonCodes();
        if (this.rank != null) {
            int index = this.rank - 1;
            String resultCode = null;
            if (index < orderedReasonCodes.size()) {
                resultCode = orderedReasonCodes.get(index);
            }
            return KiePMMLModelUtils.commonEvaluate(resultCode, this.dataType);
        }
        return null;
    }

    public Object evaluateTransformedValue(ProcessingDTO processingDTO) {
        Object toReturn = this.kiePMMLExpression != null ? this.kiePMMLExpression.evaluate(processingDTO) : null;
        return KiePMMLModelUtils.commonEvaluate(toReturn, this.dataType);
    }

    public String toString() {
        return new StringJoiner(", ", KiePMMLOutputField.class.getSimpleName() + "[", "]").add("resultFeature=" + (Object)((Object)this.resultFeature)).add("targetField='" + this.targetField + "'").add("rank=" + this.rank).add("value=" + this.value).add("name='" + this.name + "'").add("kiePMMLExpression='" + this.kiePMMLExpression + "'").add("extensions=" + this.extensions).add("id='" + this.id + "'").add("parentId='" + this.parentId + "'").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KiePMMLOutputField that = (KiePMMLOutputField)o;
        return this.resultFeature == that.resultFeature && Objects.equals(this.targetField, that.targetField) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.resultFeature, this.targetField, this.value});
    }

    public static class Builder
    extends AbstractKiePMMLComponent.Builder<KiePMMLOutputField> {
        private Builder(String name, List<KiePMMLExtension> extensions) {
            super("OutputField-", () -> new KiePMMLOutputField(name, extensions));
        }

        public Builder withResultFeature(RESULT_FEATURE resultFeature) {
            if (resultFeature != null) {
                ((KiePMMLOutputField)this.toBuild).resultFeature = resultFeature;
            }
            return this;
        }

        public Builder withTargetField(String targetField) {
            if (targetField != null) {
                ((KiePMMLOutputField)this.toBuild).targetField = targetField;
            }
            return this;
        }

        public Builder withValue(Object value) {
            ((KiePMMLOutputField)this.toBuild).value = value;
            return this;
        }

        public Builder withDataType(DATA_TYPE dataType) {
            if (dataType != null) {
                ((KiePMMLOutputField)this.toBuild).dataType = dataType;
            }
            return this;
        }

        public Builder withRank(Integer rank) {
            if (rank != null) {
                ((KiePMMLOutputField)this.toBuild).rank = rank;
            }
            return this;
        }

        public Builder withKiePMMLExpression(KiePMMLExpression kiePMMLExpression) {
            if (kiePMMLExpression != null) {
                ((KiePMMLOutputField)this.toBuild).kiePMMLExpression = kiePMMLExpression;
            }
            return this;
        }
    }
}

