/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.commit;

import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.kafka.IncomingKafkaRecord;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaExceptions;
import java.util.Collection;
import java.util.concurrent.CompletionStage;
import org.apache.kafka.common.TopicPartition;

public interface KafkaCommitHandler {
    default public <K, V> Uni<IncomingKafkaRecord<K, V>> received(IncomingKafkaRecord<K, V> record) {
        return Uni.createFrom().item(record);
    }

    default public void terminate(boolean graceful) {
    }

    default public void partitionsAssigned(Collection<TopicPartition> partitions) {
    }

    default public void partitionsRevoked(Collection<TopicPartition> partitions) {
    }

    public <K, V> CompletionStage<Void> handle(IncomingKafkaRecord<K, V> var1);

    public static enum Strategy {
        LATEST,
        IGNORE,
        THROTTLED;


        public static Strategy from(String s) {
            if (s.equalsIgnoreCase("latest")) {
                return LATEST;
            }
            if (s.equalsIgnoreCase("ignore")) {
                return IGNORE;
            }
            if (s.equalsIgnoreCase("throttled")) {
                return THROTTLED;
            }
            throw KafkaExceptions.ex.illegalArgumentUnknownCommitStrategy(s);
        }
    }
}

