/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.common.messaging.incoming;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEvent;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.kie.kogito.decision.DecisionModelMetadata;
import org.kie.kogito.tracing.decision.event.model.ModelEvent;
import org.kie.kogito.trusty.service.common.TrustyService;
import org.kie.kogito.trusty.service.common.messaging.BaseEventConsumer;
import org.kie.kogito.trusty.service.common.messaging.incoming.ModelMetadata;
import org.kie.kogito.trusty.storage.api.StorageExceptionsProvider;
import org.kie.kogito.trusty.storage.api.model.DMNModelWithMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ModelEventConsumer
extends BaseEventConsumer<ModelEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(ModelEventConsumer.class);
    private static final TypeReference<ModelEvent> CLOUD_EVENT_TYPE = new TypeReference<ModelEvent>(){};

    protected ModelEventConsumer() {
    }

    @Inject
    public ModelEventConsumer(TrustyService service, ObjectMapper mapper, StorageExceptionsProvider storageExceptionsProvider, ManagedExecutor executor) {
        super(service, mapper, storageExceptionsProvider, executor);
    }

    @Override
    @Incoming(value="kogito-tracing-model")
    public CompletionStage<Void> handleMessage(Message<String> message) {
        return CompletableFuture.runAsync(() -> super.handleMessage(message), this.executor);
    }

    @Override
    protected TypeReference<ModelEvent> getEventType() {
        return CLOUD_EVENT_TYPE;
    }

    @Override
    protected void internalHandleCloudEvent(CloudEvent cloudEvent, ModelEvent payload) {
        DecisionModelMetadata decisionModelMetadata = payload.getDecisionModelMetadata();
        if (decisionModelMetadata.getType().equals((Object)DecisionModelMetadata.Type.DMN)) {
            ModelMetadata identifier = new ModelMetadata(payload.getGav().getGroupId(), payload.getGav().getArtifactId(), payload.getGav().getVersion(), payload.getName(), payload.getNamespace());
            DMNModelWithMetadata dmnModelWithMetadata = DMNModelWithMetadata.fromCloudEvent(payload);
            this.service.storeModel(identifier, dmnModelWithMetadata);
        } else {
            LOG.error("Unsupported DecisionModelType type {}", (Object)decisionModelMetadata.getType());
        }
    }
}

