/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime;

import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.security.runtime.SecurityProviderUtils;
import java.security.Provider;

@Recorder
public class SecurityProviderRecorder {
    public void addBouncyCastleProvider(boolean inFipsMode) {
        String providerName = inFipsMode ? "org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider" : "org.bouncycastle.jce.provider.BouncyCastleProvider";
        SecurityProviderUtils.addProvider(SecurityProviderUtils.loadProvider(providerName));
    }

    public void addBouncyCastleJsseProvider() {
        Provider bc = SecurityProviderUtils.loadProvider("org.bouncycastle.jce.provider.BouncyCastleProvider");
        Provider bcJsse = SecurityProviderUtils.loadProvider("org.bouncycastle.jsse.provider.BouncyCastleJsseProvider");
        int sunJsseIndex = SecurityProviderUtils.findProviderIndex("SunJSSE");
        SecurityProviderUtils.insertProvider(bc, sunJsseIndex);
        SecurityProviderUtils.insertProvider(bcJsse, sunJsseIndex + 1);
    }

    public void addBouncyCastleFipsJsseProvider() {
        Provider bc = SecurityProviderUtils.loadProvider("org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider");
        int sunIndex = SecurityProviderUtils.findProviderIndex("SUN");
        SecurityProviderUtils.insertProvider(bc, sunIndex);
        Provider bcJsse = SecurityProviderUtils.loadProviderWithParams("org.bouncycastle.jsse.provider.BouncyCastleJsseProvider", new Class[]{Boolean.TYPE, Provider.class}, new Object[]{true, bc});
        SecurityProviderUtils.insertProvider(bcJsse, sunIndex + 1);
    }
}

